/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.handler;

import java.io.IOException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.NioQuickServer;

public class CompletionAcceptHandler
implements CompletionHandler<ServerSocketChannel, NioQuickServer> {
    public static void registerChannel(Selector selector, SelectableChannel channel, int ops) {
        try {
            if (null == channel) {
                return;
            }
            channel.configureBlocking(false);
            channel.register(selector, ops);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public void completed(ServerSocketChannel serverSocketChannel, NioQuickServer nioQuickServer) {
        SocketChannel socketChannel;
        try {
            socketChannel = serverSocketChannel.accept();
            Logger.debug("Client [{}] accepted.", socketChannel.getRemoteAddress());
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        CompletionAcceptHandler.registerChannel(nioQuickServer.getSelector(), socketChannel, 1);
    }

    @Override
    public void failed(Throwable exc, NioQuickServer nioQuickServer) {
        Logger.error(exc);
    }
}

