/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.serialize;

import org.aoju.bus.cache.serialize.BaseSerializer;
import org.aoju.bus.logger.Logger;

public abstract class AbstractSerializer
implements BaseSerializer {
    protected abstract byte[] doSerialize(Object var1) throws Throwable;

    protected abstract Object doDeserialize(byte[] var1) throws Throwable;

    @Override
    public <T> byte[] serialize(T obj) {
        if (null == obj) {
            return null;
        }
        try {
            return this.doSerialize(obj);
        }
        catch (Throwable t) {
            Logger.error("{} serialize error.", this.getClass().getName(), t);
            return null;
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        try {
            return (T)this.doDeserialize(bytes);
        }
        catch (Throwable t) {
            Logger.error("{} deserialize error.", this.getClass().getName(), t);
            return null;
        }
    }
}

