/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.aoju.bus.core.annotation.Ignore;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.AnnoKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class PropertyDesc {
    protected final Field field;
    protected Method getter;
    protected Method setter;

    public PropertyDesc(Field field, Method getter, Method setter) {
        this.field = field;
        this.getter = ClassKit.setAccessible(getter);
        this.setter = ClassKit.setAccessible(setter);
    }

    public String getFieldName() {
        return ReflectKit.getFieldName(this.field);
    }

    public String getRawFieldName() {
        return null == this.field ? null : this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return TypeKit.getType(this.field);
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return TypeKit.getClass(this.field);
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        if (null == this.getter && !BeanKit.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForGet()) {
            return false;
        }
        return false == this.isIgnoreGet();
    }

    public Object getValue(Object bean) {
        if (null != this.getter) {
            return ReflectKit.invoke(bean, this.getter, new Object[0]);
        }
        if (BeanKit.isPublic(this.field)) {
            return ReflectKit.getFieldValue(bean, this.field);
        }
        return null;
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result;
        block3: {
            result = null;
            try {
                result = this.getValue(bean);
            }
            catch (Exception e) {
                if (ignoreError) break block3;
                throw new InstrumentException("Get value of [{}] error!", this.getFieldName());
            }
        }
        if (null != result && null != targetType) {
            return Convert.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        if (null == this.setter && !BeanKit.isPublic(this.field)) {
            return false;
        }
        if (checkTransient && this.isTransientForSet()) {
            return false;
        }
        return false == this.isIgnoreSet();
    }

    public PropertyDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            ReflectKit.invoke(bean, this.setter, value);
        } else if (BeanKit.isPublic(this.field)) {
            ReflectKit.setFieldValue(bean, this.field, value);
        }
        return this;
    }

    public PropertyDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public PropertyDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new InstrumentException("Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private Type findPropType(Method getter, Method setter) {
        Type type = null;
        if (null != getter) {
            type = TypeKit.getReturnType(getter);
        }
        if (null == type && null != setter) {
            type = TypeKit.getParamType(setter, 0);
        }
        return type;
    }

    private Class<?> findPropClass(Method getter, Method setter) {
        Class<?> type = null;
        if (null != getter) {
            type = TypeKit.getReturnClass(getter);
        }
        if (null == type && null != setter) {
            type = TypeKit.getFirstParamClass(setter);
        }
        return type;
    }

    private boolean isIgnoreSet() {
        return AnnoKit.hasAnnotation(this.field, Ignore.class) || AnnoKit.hasAnnotation(this.setter, Ignore.class);
    }

    private boolean isIgnoreGet() {
        return AnnoKit.hasAnnotation(this.field, Ignore.class) || AnnoKit.hasAnnotation(this.getter, Ignore.class);
    }

    private boolean isTransientForGet() {
        boolean isTransient = BeanKit.hasModifier(this.field, BeanKit.ModifierType.TRANSIENT);
        if (!isTransient && null != this.getter && !(isTransient = BeanKit.hasModifier(this.getter, BeanKit.ModifierType.TRANSIENT))) {
            isTransient = AnnoKit.hasAnnotation(this.getter, Transient.class);
        }
        return isTransient;
    }

    private boolean isTransientForSet() {
        boolean isTransient = BeanKit.hasModifier(this.field, BeanKit.ModifierType.TRANSIENT);
        if (!isTransient && null != this.setter && !(isTransient = BeanKit.hasModifier(this.setter, BeanKit.ModifierType.TRANSIENT))) {
            isTransient = AnnoKit.hasAnnotation(this.setter, Transient.class);
        }
        return isTransient;
    }
}

