/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.bloom;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.BitSet;
import org.aoju.bus.core.bloom.BloomFilter;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.HashKit;
import org.aoju.bus.core.toolkit.IoKit;

public class BitSetBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private final BitSet bitSet;
    private final int bitSetSize;
    private final int addedElements;
    private final int hashFunctionNumber;

    public BitSetBloomFilter(int c, int n, int k) {
        this.hashFunctionNumber = k;
        this.bitSetSize = (int)Math.ceil(c * k);
        this.addedElements = n;
        this.bitSet = new BitSet(this.bitSetSize);
    }

    public static int[] createHashes(String text, int hashNumber) {
        int[] result = new int[hashNumber];
        for (int i = 0; i < hashNumber; ++i) {
            result[i] = BitSetBloomFilter.hash(text, i);
        }
        return result;
    }

    public static int hash(String text, int k) {
        switch (k) {
            case 0: {
                return HashKit.rsHash(text);
            }
            case 1: {
                return HashKit.jsHash(text);
            }
            case 2: {
                return HashKit.elfHash(text);
            }
            case 3: {
                return HashKit.bkdrHash(text);
            }
            case 4: {
                return HashKit.apHash(text);
            }
            case 5: {
                return HashKit.djbHash(text);
            }
            case 6: {
                return HashKit.sdbmHash(text);
            }
            case 7: {
                return HashKit.pjwHash(text);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path, String charset) throws IOException {
        BufferedReader reader = FileKit.getReader(path, charset);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.add(line);
            }
        }
        finally {
            IoKit.close(reader);
        }
    }

    @Override
    public boolean add(String text) {
        int[] positions;
        if (this.contains(text)) {
            return false;
        }
        for (int value : positions = BitSetBloomFilter.createHashes(text, this.hashFunctionNumber)) {
            int position = Math.abs(value % this.bitSetSize);
            this.bitSet.set(position, true);
        }
        return true;
    }

    @Override
    public boolean contains(String text) {
        int[] positions;
        for (int i : positions = BitSetBloomFilter.createHashes(text, this.hashFunctionNumber)) {
            int position = Math.abs(i % this.bitSetSize);
            if (this.bitSet.get(position)) continue;
            return false;
        }
        return true;
    }

    public double getFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.hashFunctionNumber) * (double)this.addedElements / (double)this.bitSetSize), this.hashFunctionNumber);
    }
}

