/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.aoju.bus.core.compiler.JavaSourceFileObject;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ZipKit;

public class JavaFileObject {
    public static List<javax.tools.JavaFileObject> getJavaFileObjects(File file) {
        ArrayList<javax.tools.JavaFileObject> result = new ArrayList<javax.tools.JavaFileObject>();
        String fileName = file.getName();
        if (JavaFileObject.isJavaFile(fileName)) {
            result.add(new JavaSourceFileObject(file.toURI()));
        } else if (JavaFileObject.isJarOrZipFile(fileName)) {
            result.addAll(JavaFileObject.getJavaFileObjectByZipOrJarFile(file));
        }
        return result;
    }

    public static boolean isJarOrZipFile(String fileName) {
        return FileKit.isType(fileName, "jar", "zip");
    }

    public static boolean isJavaFile(String fileName) {
        return FileKit.isType(fileName, "java");
    }

    private static List<javax.tools.JavaFileObject> getJavaFileObjectByZipOrJarFile(File file) {
        ArrayList<javax.tools.JavaFileObject> collection = new ArrayList<javax.tools.JavaFileObject>();
        ZipFile zipFile = ZipKit.zipFile(file, null);
        ZipKit.get(zipFile, zipEntry -> {
            String name = zipEntry.getName();
            if (JavaFileObject.isJavaFile(name)) {
                collection.add(new JavaSourceFileObject(name, ZipKit.get(zipFile, zipEntry)));
            }
        });
        return collection;
    }
}

