/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.date.Kalendar;
import org.aoju.bus.core.date.Lunar;
import org.aoju.bus.core.date.Solar;
import org.aoju.bus.core.lang.Fields;

public class EightChar {
    public static final String[] CHANG_SHENG = new String[]{"\u957f\u751f", "\u6c90\u6d74", "\u51a0\u5e26", "\u4e34\u5b98", "\u5e1d\u65fa", "\u8870", "\u75c5", "\u6b7b", "\u5893", "\u7edd", "\u80ce", "\u517b"};
    private static final String[] MONTH_ZHI = new String[]{"\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5", "\u5b50", "\u4e11"};
    private static final Map<String, Integer> CHANG_SHENG_OFFSET = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("\u7532", 1);
            this.put("\u4e19", 10);
            this.put("\u620a", 10);
            this.put("\u5e9a", 7);
            this.put("\u58ec", 4);
            this.put("\u4e59", 6);
            this.put("\u4e01", 9);
            this.put("\u5df1", 9);
            this.put("\u8f9b", 0);
            this.put("\u7678", 3);
        }
    };
    protected int sect = 2;
    protected Lunar lunar;

    public EightChar(Lunar lunar) {
        this.lunar = lunar;
    }

    public static EightChar fromLunar(Lunar lunar) {
        return new EightChar(lunar);
    }

    public int getSect() {
        return this.sect;
    }

    public void setSect(int sect) {
        this.sect = 1 == sect ? 1 : 2;
    }

    public String getYear() {
        return this.lunar.getYearInGanZhiExact();
    }

    public String getYearGan() {
        return this.lunar.getYearGanExact();
    }

    public String getYearZhi() {
        return this.lunar.getYearZhiExact();
    }

    public List<String> getYearHideGan() {
        return Lunar.ZHI_HIDE_GAN.get(this.getYearZhi());
    }

    public String getYearWuXing() {
        return Lunar.WU_XING_GAN.get(this.getYearGan()) + Lunar.WU_XING_ZHI.get(this.getYearZhi());
    }

    public String getYearNaYin() {
        return Lunar.NAYIN.get(this.getYear());
    }

    public String getYearShiShenGan() {
        return Lunar.SHI_SHEN_GAN.get(this.getDayGan() + this.getYearGan());
    }

    private List<String> getShiShenZhi(String zhi) {
        List<String> hideGan = Lunar.ZHI_HIDE_GAN.get(zhi);
        ArrayList<String> l = new ArrayList<String>(hideGan.size());
        for (String gan : hideGan) {
            l.add(Lunar.SHI_SHEN_ZHI.get(this.getDayGan() + zhi + gan));
        }
        return l;
    }

    public List<String> getYearShiShenZhi() {
        return this.getShiShenZhi(this.getYearZhi());
    }

    public int getDayGanIndex() {
        return 2 == this.sect ? this.lunar.getDayGanIndexExact2() : this.lunar.getDayGanIndexExact();
    }

    public int getDayZhiIndex() {
        return 2 == this.sect ? this.lunar.getDayZhiIndexExact2() : this.lunar.getDayZhiIndexExact();
    }

    private String getDiShi(int zhiIndex) {
        int offset = CHANG_SHENG_OFFSET.get(this.getDayGan());
        int index = offset + (this.getDayGanIndex() % 2 == 0 ? zhiIndex : -zhiIndex);
        if (index >= 12) {
            index -= 12;
        }
        if (index < 0) {
            index += 12;
        }
        return CHANG_SHENG[index];
    }

    public String getYearDiShi() {
        return this.getDiShi(this.lunar.getYearZhiIndexExact());
    }

    public String getMonth() {
        return this.lunar.getMonthInGanZhiExact();
    }

    public String getMonthGan() {
        return this.lunar.getMonthGanExact();
    }

    public String getMonthZhi() {
        return this.lunar.getMonthZhiExact();
    }

    public List<String> getMonthHideGan() {
        return Lunar.ZHI_HIDE_GAN.get(this.getMonthZhi());
    }

    public String getMonthWuXing() {
        return Lunar.WU_XING_GAN.get(this.getMonthGan()) + Lunar.WU_XING_ZHI.get(this.getMonthZhi());
    }

    public String getMonthNaYin() {
        return Lunar.NAYIN.get(this.getMonth());
    }

    public String getMonthShiShenGan() {
        return Lunar.SHI_SHEN_GAN.get(this.getDayGan() + this.getMonthGan());
    }

    public List<String> getMonthShiShenZhi() {
        return this.getShiShenZhi(this.getMonthZhi());
    }

    public String getMonthDiShi() {
        return this.getDiShi(this.lunar.getMonthZhiIndexExact());
    }

    public String getDay() {
        return 2 == this.sect ? this.lunar.getDayInGanZhiExact2() : this.lunar.getDayInGanZhiExact();
    }

    public String getDayGan() {
        return 2 == this.sect ? this.lunar.getDayGanExact2() : this.lunar.getDayGanExact();
    }

    public String getDayZhi() {
        return 2 == this.sect ? this.lunar.getDayZhiExact2() : this.lunar.getDayZhiExact();
    }

    public List<String> getDayHideGan() {
        return Lunar.ZHI_HIDE_GAN.get(this.getDayZhi());
    }

    public String getDayWuXing() {
        return Lunar.WU_XING_GAN.get(this.getDayGan()) + Lunar.WU_XING_ZHI.get(this.getDayZhi());
    }

    public String getDayNaYin() {
        return Lunar.NAYIN.get(this.getDay());
    }

    public String getDayShiShenGan() {
        return "\u65e5\u4e3b";
    }

    public List<String> getDayShiShenZhi() {
        return this.getShiShenZhi(this.getDayZhi());
    }

    public String getDayDiShi() {
        return this.getDiShi(this.getDayZhiIndex());
    }

    public String getTime() {
        return this.lunar.getTimeInGanZhi();
    }

    public String getTimeGan() {
        return this.lunar.getTimeGan();
    }

    public String getTimeZhi() {
        return this.lunar.getTimeZhi();
    }

    public List<String> getTimeHideGan() {
        return Lunar.ZHI_HIDE_GAN.get(this.getTimeZhi());
    }

    public String getTimeWuXing() {
        return Lunar.WU_XING_GAN.get(this.lunar.getTimeGan()) + Lunar.WU_XING_ZHI.get(this.lunar.getTimeZhi());
    }

    public String getTimeNaYin() {
        return Lunar.NAYIN.get(this.getTime());
    }

    public String getTimeShiShenGan() {
        return Lunar.SHI_SHEN_GAN.get(this.getDayGan() + this.getTimeGan());
    }

    public List<String> getTimeShiShenZhi() {
        return this.getShiShenZhi(this.getTimeZhi());
    }

    public String getTimeDiShi() {
        return this.getDiShi(this.lunar.getTimeZhiIndex());
    }

    public String getTaiYuan() {
        int zhiIndex;
        int ganIndex = this.lunar.getMonthGanIndexExact() + 1;
        if (ganIndex >= 10) {
            ganIndex -= 10;
        }
        if ((zhiIndex = this.lunar.getMonthZhiIndexExact() + 3) >= 12) {
            zhiIndex -= 12;
        }
        return Fields.CN_GAN[ganIndex] + Fields.CN_ZHI[zhiIndex];
    }

    public String getTaiYuanNaYin() {
        return Lunar.NAYIN.get(this.getTaiYuan());
    }

    public String getMingGong() {
        int jiaZiIndex;
        int monthZhiIndex = 0;
        int timeZhiIndex = 0;
        int j = MONTH_ZHI.length;
        for (int i = 0; i < j; ++i) {
            String zhi = MONTH_ZHI[i];
            if (this.lunar.getMonthZhiExact().equals(zhi)) {
                monthZhiIndex = i;
            }
            if (!this.lunar.getTimeZhi().equals(zhi)) continue;
            timeZhiIndex = i;
        }
        int zhiIndex = 26 - (monthZhiIndex + timeZhiIndex);
        if (zhiIndex > 12) {
            zhiIndex -= 12;
        }
        if ((jiaZiIndex = Lunar.getJiaZiIndex(this.lunar.getMonthInGanZhiExact()) - (monthZhiIndex - zhiIndex)) >= 60) {
            jiaZiIndex -= 60;
        }
        if (jiaZiIndex < 0) {
            jiaZiIndex += 60;
        }
        return Fields.CN_JIA_ZI[jiaZiIndex];
    }

    public String getMingGongNaYin() {
        return Lunar.NAYIN.get(this.getMingGong());
    }

    public String getShenGong() {
        int monthZhiIndex = 0;
        int timeZhiIndex = 0;
        int j = MONTH_ZHI.length;
        for (int i = 0; i < j; ++i) {
            String zhi = MONTH_ZHI[i];
            if (this.lunar.getMonthZhiExact().equals(zhi)) {
                monthZhiIndex = i;
            }
            if (!this.lunar.getTimeZhi().equals(zhi)) continue;
            timeZhiIndex = i;
        }
        int zhiIndex = (2 + (monthZhiIndex + timeZhiIndex)) % 12;
        int jiaZiIndex = Lunar.getJiaZiIndex(this.lunar.getMonthInGanZhiExact()) - (monthZhiIndex - zhiIndex);
        if (jiaZiIndex >= 60) {
            jiaZiIndex -= 60;
        }
        if (jiaZiIndex < 0) {
            jiaZiIndex += 60;
        }
        return Fields.CN_JIA_ZI[jiaZiIndex];
    }

    public String getShenGongNaYin() {
        return Lunar.NAYIN.get(this.getShenGong());
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public Yun getYun(int gender) {
        return new Yun(this, gender);
    }

    public String getYearXun() {
        return this.lunar.getYearXunExact();
    }

    public String getYearXunKong() {
        return this.lunar.getYearXunKongExact();
    }

    public String getMonthXun() {
        return this.lunar.getMonthXunExact();
    }

    public String getMonthXunKong() {
        return this.lunar.getMonthXunKongExact();
    }

    public String getDayXun() {
        return 2 == this.sect ? this.lunar.getDayXunExact2() : this.lunar.getDayXunExact();
    }

    public String getDayXunKong() {
        return 2 == this.sect ? this.lunar.getDayXunKongExact2() : this.lunar.getDayXunKongExact();
    }

    public String getTimeXun() {
        return this.lunar.getTimeXun();
    }

    public String getTimeXunKong() {
        return this.lunar.getTimeXunKong();
    }

    public String build(boolean ... args) {
        return this.getYear() + " " + this.getMonth() + " " + this.getDay() + " " + this.getTime();
    }

    public static class Yun {
        private final int gender;
        private final boolean forward;
        private final Lunar lunar;
        private int startYear;
        private int startMonth;
        private int startDay;

        public Yun(EightChar eightChar, int gender) {
            this.lunar = eightChar.getLunar();
            this.gender = gender;
            boolean yang = 0 == this.lunar.getYearGanIndexExact() % 2;
            boolean man = 1 == gender;
            this.forward = yang && man || !yang && !man;
            this.compute();
        }

        private void compute() {
            Lunar.SolarTerm prev = this.lunar.getPrevJie();
            Lunar.SolarTerm next = this.lunar.getNextJie();
            Solar current = this.lunar.getSolar();
            Solar start = this.forward ? current : prev.getSolar();
            Solar end = this.forward ? next.getSolar() : current;
            int endTimeZhiIndex = end.getHour() == 23 ? 11 : Lunar.getTimeZhiIndex(end.build(false).substring(11, 16));
            int startTimeZhiIndex = start.getHour() == 23 ? 11 : Lunar.getTimeZhiIndex(start.build(false).substring(11, 16));
            int hourDiff = endTimeZhiIndex - startTimeZhiIndex;
            int dayDiff = Solar.getDays(start.getYear(), start.getMonth(), start.getDay(), end.getYear(), end.getMonth(), end.getDay());
            if (hourDiff < 0) {
                hourDiff += 12;
                --dayDiff;
            }
            int monthDiff = hourDiff * 10 / 30;
            int month = dayDiff * 4 + monthDiff;
            int day = hourDiff * 10 - monthDiff * 30;
            int year = month / 12;
            this.startYear = year;
            this.startMonth = month -= year * 12;
            this.startDay = day;
        }

        public int getGender() {
            return this.gender;
        }

        public int getStartYear() {
            return this.startYear;
        }

        public int getStartMonth() {
            return this.startMonth;
        }

        public int getStartDay() {
            return this.startDay;
        }

        public boolean isForward() {
            return this.forward;
        }

        public Lunar getLunar() {
            return this.lunar;
        }

        public Solar getStartSolar() {
            Solar birth = this.lunar.getSolar();
            Calendar calendar = Kalendar.calendar(birth.getYear(), birth.getMonth(), birth.getDay());
            calendar.add(1, this.startYear);
            calendar.add(2, this.startMonth);
            calendar.add(5, this.startDay);
            return Solar.from(calendar);
        }

        public DaYun[] getDaYun() {
            return this.getDaYun(10);
        }

        public DaYun[] getDaYun(int n) {
            DaYun[] l = new DaYun[n];
            for (int i = 0; i < n; ++i) {
                l[i] = new DaYun(this, i);
            }
            return l;
        }
    }

    public static class XiaoYun {
        private final int index;
        private final DaYun daYun;
        private final int year;
        private final int age;
        private final boolean forward;
        private final Lunar lunar;

        public XiaoYun(DaYun daYun, int index, boolean forward) {
            this.daYun = daYun;
            this.lunar = daYun.getLunar();
            this.index = index;
            this.year = daYun.getStartYear() + index;
            this.age = daYun.getStartAge() + index;
            this.forward = forward;
        }

        public int getIndex() {
            return this.index;
        }

        public int getYear() {
            return this.year;
        }

        public int getAge() {
            return this.age;
        }

        public String getGanZhi() {
            int offset = Lunar.getJiaZiIndex(this.lunar.getTimeInGanZhi());
            int add = this.index + 1;
            if (this.daYun.getIndex() > 0) {
                add += this.daYun.getStartAge() - 1;
            }
            offset += this.forward ? add : -add;
            int size = Fields.CN_JIA_ZI.length;
            while (offset < 0) {
                offset += size;
            }
            return Fields.CN_JIA_ZI[offset %= size];
        }

        public String getXun() {
            return Lunar.getXun(this.getGanZhi());
        }

        public String getXunKong() {
            return Lunar.getXunKong(this.getGanZhi());
        }
    }

    public static class LiuYue {
        private final int index;
        private final LiuNian liuNian;

        public LiuYue(LiuNian liuNian, int index) {
            this.liuNian = liuNian;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public String getMonthInChinese() {
            return Fields.CN_MONTH[this.index];
        }

        public String getGanZhi() {
            int offset = 0;
            String yearGan = this.liuNian.getGanZhi().substring(0, 1);
            if ("\u7532".equals(yearGan) || "\u5df1".equals(yearGan)) {
                offset = 2;
            } else if ("\u4e59".equals(yearGan) || "\u5e9a".equals(yearGan)) {
                offset = 4;
            } else if ("\u4e19".equals(yearGan) || "\u8f9b".equals(yearGan)) {
                offset = 6;
            } else if ("\u4e01".equals(yearGan) || "\u58ec".equals(yearGan)) {
                offset = 8;
            }
            String gan = Fields.CN_GAN[(this.index + offset) % 10];
            String zhi = Fields.CN_ZHI[(this.index + 2) % 12];
            return gan + zhi;
        }

        public String getXun() {
            return Lunar.getXun(this.getGanZhi());
        }

        public String getXunKong() {
            return Lunar.getXunKong(this.getGanZhi());
        }
    }

    public static class LiuNian {
        private final int index;
        private final DaYun daYun;
        private final int year;
        private final int age;
        private final Lunar lunar;

        public LiuNian(DaYun daYun, int index) {
            this.daYun = daYun;
            this.lunar = daYun.getLunar();
            this.index = index;
            this.year = daYun.getStartYear() + index;
            this.age = daYun.getStartAge() + index;
        }

        public int getIndex() {
            return this.index;
        }

        public int getYear() {
            return this.year;
        }

        public int getAge() {
            return this.age;
        }

        public String getGanZhi() {
            int offset = Lunar.getJiaZiIndex(this.lunar.getSolarTermTable().get("\u7acb\u6625").getLunar().getYearInGanZhiExact()) + this.index;
            if (this.daYun.getIndex() > 0) {
                offset += this.daYun.getStartAge() - 1;
            }
            return Fields.CN_JIA_ZI[offset %= Fields.CN_JIA_ZI.length];
        }

        public String getXun() {
            return Lunar.getXun(this.getGanZhi());
        }

        public String getXunKong() {
            return Lunar.getXunKong(this.getGanZhi());
        }

        public LiuYue[] getLiuYue() {
            int n = 12;
            LiuYue[] l = new LiuYue[n];
            for (int i = 0; i < n; ++i) {
                l[i] = new LiuYue(this, i);
            }
            return l;
        }
    }

    public static class DaYun {
        private final int startYear;
        private final int endYear;
        private final int startAge;
        private final int endAge;
        private final int index;
        private final Yun yun;
        private final Lunar lunar;

        public DaYun(Yun yun, int index) {
            this.yun = yun;
            this.lunar = yun.getLunar();
            this.index = index;
            int birthYear = this.lunar.getSolar().getYear();
            int year = yun.getStartSolar().getYear();
            if (index < 1) {
                this.startYear = birthYear;
                this.startAge = 1;
                this.endYear = year - 1;
                this.endAge = year - birthYear;
            } else {
                int add = (index - 1) * 10;
                this.startYear = year + add;
                this.startAge = this.startYear - birthYear + 1;
                this.endYear = this.startYear + 9;
                this.endAge = this.startAge + 9;
            }
        }

        public int getStartYear() {
            return this.startYear;
        }

        public int getEndYear() {
            return this.endYear;
        }

        public int getStartAge() {
            return this.startAge;
        }

        public int getEndAge() {
            return this.endAge;
        }

        public int getIndex() {
            return this.index;
        }

        public Lunar getLunar() {
            return this.lunar;
        }

        public String getGanZhi() {
            int size;
            if (this.index < 1) {
                return "";
            }
            int offset = Lunar.getJiaZiIndex(this.lunar.getMonthInGanZhiExact());
            if ((offset += this.yun.isForward() ? this.index : -this.index) >= (size = Fields.CN_JIA_ZI.length)) {
                offset -= size;
            }
            if (offset < 0) {
                offset += size;
            }
            return Fields.CN_JIA_ZI[offset];
        }

        public String getXun() {
            return Lunar.getXun(this.getGanZhi());
        }

        public String getXunKong() {
            return Lunar.getXunKong(this.getGanZhi());
        }

        public LiuNian[] getLiuNian() {
            return this.getLiuNian(10);
        }

        public LiuNian[] getLiuNian(int n) {
            if (this.index < 1) {
                n = this.endYear - this.startYear + 1;
            }
            LiuNian[] l = new LiuNian[n];
            for (int i = 0; i < n; ++i) {
                l[i] = new LiuNian(this, i);
            }
            return l;
        }

        public XiaoYun[] getXiaoYun() {
            return this.getXiaoYun(10);
        }

        public XiaoYun[] getXiaoYun(int n) {
            if (this.index < 1) {
                n = this.endYear - this.startYear + 1;
            }
            XiaoYun[] l = new XiaoYun[n];
            for (int i = 0; i < n; ++i) {
                l[i] = new XiaoYun(this, i, this.yun.isForward());
            }
            return l;
        }
    }
}

