/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.painter;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.TextElement;
import org.aoju.bus.core.image.painter.Painter;
import org.aoju.bus.core.toolkit.StringKit;

public class TextPainter
implements Painter {
    @Override
    public void draw(Graphics2D g, AbstractElement element, int canvasWidth) {
        TextElement textElement = (TextElement)element;
        List<Object> textLineElements = new ArrayList<TextElement>();
        textLineElements.add(textElement);
        if (textElement.isAutoBreakLine()) {
            textLineElements = this.getBreakLineElements(textElement);
        }
        for (int i = 0; i < textLineElements.size(); ++i) {
            TextElement textLineElement = (TextElement)textLineElements.get(i);
            int textWidth = 0;
            g.setFont(textLineElement.getFont());
            g.setColor(textLineElement.getColor());
            if (textLineElement.isCenter()) {
                if (i == 0) {
                    textWidth = this.getFrontWidth(textLineElement.getText(), textLineElement.getFont());
                    int centerX = (canvasWidth - textWidth) / 2;
                    textLineElement.setX(centerX);
                } else {
                    textLineElement.setX(((TextElement)textLineElements.get(0)).getX());
                }
            }
            if (null != textLineElement.getRotate()) {
                if (textWidth == 0) {
                    textWidth = this.getFrontWidth(textLineElement.getText(), textLineElement.getFont());
                }
                g.rotate(Math.toRadians(textLineElement.getRotate().intValue()), textLineElement.getX() + textWidth / 2, textLineElement.getY());
            }
            g.setComposite(AlphaComposite.getInstance(3, textLineElement.getAlpha()));
            if (textLineElement.isStrikeThrough()) {
                AttributedString as = new AttributedString(textLineElement.getText());
                as.addAttribute(TextAttribute.FONT, textLineElement.getFont());
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, textLineElement.getText().length());
                g.drawString(as.getIterator(), textLineElement.getX(), textLineElement.getY());
            } else {
                g.drawString(textLineElement.getText(), textLineElement.getX(), textLineElement.getY());
            }
            if (null == textLineElement.getRotate()) continue;
            g.rotate(-Math.toRadians(textLineElement.getRotate().intValue()), textLineElement.getX() + textWidth / 2, textLineElement.getY());
        }
    }

    public int getFrontWidth(String text, Font font) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        FontMetrics metrics = image.createGraphics().getFontMetrics(font);
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            width += metrics.charWidth(text.charAt(i));
        }
        return width;
    }

    private boolean isChineseChar(char c) {
        return String.valueOf(c).matches("[\u4e00-\u9fa5]");
    }

    private List<String> computeLines(String text, Font font, int maxLineWidth) {
        ArrayList<String> computedLines = new ArrayList<String>();
        String strToComputer = "";
        String word = "";
        boolean hasWord = false;
        char[] chars = text.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length && count++ <= 500; ++i) {
            char c = chars[i];
            if (this.isChineseChar(c) || c == ' ' || i == chars.length - 1) {
                word = word + c;
                hasWord = true;
            } else {
                word = word + c;
            }
            if (!hasWord) continue;
            int originWidth = this.getFrontWidth(strToComputer, font);
            int wordWidth = this.getFrontWidth(word, font);
            strToComputer = strToComputer + word;
            int newWidth = originWidth + wordWidth;
            if (wordWidth > maxLineWidth) {
                int fetch = (int)((float)(maxLineWidth - originWidth) / (float)wordWidth * (float)word.length());
                strToComputer = strToComputer.substring(0, strToComputer.length() - word.length() + fetch);
                computedLines.add(strToComputer);
                strToComputer = "";
                i -= word.length() - fetch;
            } else if (newWidth > maxLineWidth) {
                strToComputer = strToComputer.substring(0, strToComputer.length() - word.length());
                computedLines.add(strToComputer);
                strToComputer = "";
                i -= word.length();
            }
            word = "";
            hasWord = false;
        }
        if (StringKit.isNotEmpty(strToComputer)) {
            computedLines.add(strToComputer);
        }
        return computedLines;
    }

    public List<TextElement> getBreakLineElements(TextElement textElement) {
        ArrayList<TextElement> breakLineElements = new ArrayList<TextElement>();
        List<String> breakLineTexts = this.computeLines(textElement.getText(), textElement.getFont(), textElement.getMaxLineWidth());
        int y = textElement.getY();
        for (int i = 0; i < breakLineTexts.size() && i < textElement.getMaxLineCount(); ++i) {
            String text = breakLineTexts.get(i);
            if (i == textElement.getMaxLineCount() - 1 && i < breakLineTexts.size() - 1) {
                text = text.substring(0, text.length() - 1) + "...";
            }
            TextElement combineTextLine = new TextElement(text, textElement.getFont(), textElement.getX(), y);
            combineTextLine.setColor(textElement.getColor());
            combineTextLine.setStrikeThrough(textElement.isStrikeThrough());
            combineTextLine.setCenter(textElement.isCenter());
            combineTextLine.setAlpha(textElement.getAlpha());
            combineTextLine.setRotate(textElement.getRotate());
            breakLineElements.add(combineTextLine);
            y += textElement.getLineHeight();
        }
        return breakLineElements;
    }
}

