/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.Properties;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.toolkit.StringKit;

public class System {
    public static final String VERSION = "java.version";
    public static final String VENDOR = "java.vendor";
    public static final String VENDOR_URL = "java.vendor.url";
    public static final String HOME = "java.home";
    public static final String VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String VM_SPECIFICATION_NAME = "java.vm.specification.name";
    public static final String VM_VERSION = "java.vm.version";
    public static final String VM_VENDOR = "java.vm.vendor";
    public static final String VM_NAME = "java.vm.name";
    public static final String VM_INFO = " java.vm.info";
    public static final String SPECIFICATION_VERSION = "java.specification.version";
    public static final String SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String SPECIFICATION_NAME = "java.specification.name";
    public static final String CLASS_VERSION = "java.class.version";
    public static final String CLASS_PATH = "java.class.path";
    public static final String LIBRARY_PATH = "java.library.path";
    public static final String IO_TMPDIR = "java.io.tmpdir";
    public static final String COMPILER = "java.compiler";
    public static final String EXT_DIRS = "java.ext.dirs";
    public static final String OS_NAME = "os.name";
    public static final String OS_ARCH = "os.arch";
    public static final String OS_VERSION = "os.version";
    public static final String FILE_SEPARATOR = "file.separator";
    public static final String PATH_SEPARATOR = "path.separator";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String USER_NAME = "user.name";
    public static final String USER_HOME = "user.home";
    public static final String USER_DIR = "user.dir";
    public static final String USER_LANGUAGE = "user.language";
    public static final String USER_COUNTRY = "user.country";
    public static final String USER_REGION = "user.region";
    public static final String RUNTIME_NAME = " java.runtime.name";
    public static final String RUNTIME_VERSION = "java.runtime.version";
    public static final String ENDORSED_DIRS = "java.endorsed.dirs";
    public static final String SUN_CLASS_PATH = "sun.boot.class.path";
    public static final String SUN_DATA_MODEL = "sun.arch.data.model";
    public static String BUS_DATE_LENIENT = "bus.date.lenient";

    public static String getProperty(String key) {
        return java.lang.System.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return java.lang.System.getProperty(key, def);
    }

    public static Properties getProperties() {
        return java.lang.System.getProperties();
    }

    public static String clearProperty(String key) {
        return java.lang.System.clearProperty(key);
    }

    public static String get(String name, String defaultValue) {
        return StringKit.nullToDefault(System.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        String value;
        block6: {
            block5: {
                value = null;
                try {
                    value = java.lang.System.getProperty(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the SystemUtil property value will default to null.", name);
                }
            }
            if (null == value) {
                try {
                    value = java.lang.System.getenv(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the SystemUtil env value will default to null.", name);
                }
            }
        }
        return value;
    }

    public static String get(String key) {
        return System.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = System.get(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        return Convert.toBool(value, defaultValue);
    }

    public static long getInt(String key, int defaultValue) {
        return Convert.toInt(System.get(key), defaultValue).intValue();
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(System.get(key), defaultValue);
    }

    public static Properties getProps() {
        return java.lang.System.getProperties();
    }

    public static void set(String key, String value) {
        if (null == value) {
            java.lang.System.clearProperty(key);
        } else {
            java.lang.System.setProperty(key, value);
        }
    }
}

