/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.map.CustomKeyMap;
import org.aoju.bus.core.toolkit.StringKit;

public class CamelCaseLinkedMap<K, V>
extends CustomKeyMap<K, V> {
    public CamelCaseLinkedMap() {
        this(16);
    }

    public CamelCaseLinkedMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CamelCaseLinkedMap(Map<? extends K, ? extends V> m) {
        this(0.75f, m);
    }

    public CamelCaseLinkedMap(float loadFactor, Map<? extends K, ? extends V> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public CamelCaseLinkedMap(int initialCapacity, float loadFactor) {
        super(new LinkedHashMap(initialCapacity, loadFactor));
    }

    @Override
    protected Object customKey(Object key) {
        if (key instanceof CharSequence) {
            key = StringKit.toCamelCase(key.toString());
        }
        return key;
    }
}

