/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.function.Func0;
import org.aoju.bus.core.map.AbsCollValueMap;

public class CollectionValueMap<K, V>
extends AbsCollValueMap<K, V, Collection<V>> {
    private final Func0<Collection<V>> collectionCreateFunc;

    public CollectionValueMap() {
        this(16);
    }

    public CollectionValueMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CollectionValueMap(Map<? extends K, ? extends Collection<V>> m) {
        this(0.75f, (Map<? extends K, Collection<V>>)m);
    }

    public CollectionValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m) {
        this(loadFactor, m, ArrayList::new);
    }

    public CollectionValueMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, ArrayList::new);
    }

    public CollectionValueMap(float loadFactor, Map<? extends K, ? extends Collection<V>> m, Func0<Collection<V>> collectionCreateFunc) {
        this(m.size(), loadFactor, collectionCreateFunc);
        this.putAll(m);
    }

    public CollectionValueMap(int initialCapacity, float loadFactor, Func0<Collection<V>> collectionCreateFunc) {
        super(new HashMap(initialCapacity, loadFactor));
        this.collectionCreateFunc = collectionCreateFunc;
    }

    @Override
    protected Collection<V> createCollection() {
        return this.collectionCreateFunc.callWithRuntimeException();
    }
}

