/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.core.toolkit.MathKit;

public class Arrange {
    private final String[] datas;

    public Arrange(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n) {
        return Arrange.count(n, n);
    }

    public static long count(int n, int m) {
        if (n == m) {
            return MathKit.factorial(n);
        }
        return n > m ? MathKit.factorial(n, n - m) : 0L;
    }

    public static long countAll(int n) {
        long total = 0L;
        for (int i = 1; i <= n; ++i) {
            total += Arrange.count(n, i);
        }
        return total;
    }

    public List<String[]> select() {
        return this.select(this.datas.length);
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrange.count(this.datas.length, m));
        this.select(new String[m], 0, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrange.countAll(this.datas.length));
        for (int i = 1; i <= this.datas.length; ++i) {
            result.addAll(this.select(i));
        }
        return result;
    }

    private void select(String[] resultList, int resultIndex, List<String[]> result) {
        int resultLen = resultList.length;
        if (resultIndex >= resultLen) {
            result.add(Arrays.copyOf(resultList, resultList.length));
            return;
        }
        for (int i = 0; i < this.datas.length; ++i) {
            boolean exists = false;
            for (int j = 0; j < resultIndex; ++j) {
                if (!this.datas[i].equals(resultList[j])) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            resultList[resultIndex] = this.datas[i];
            this.select(resultList, resultIndex + 1, result);
        }
    }
}

