/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.util.Arrays;
import org.aoju.bus.core.toolkit.StringKit;

public abstract class Matchers {
    private static final Matchers COMMA_MATCHER = new CharMatcher(',');
    private static final Matchers TAB_MATCHER = new CharMatcher('\t');
    private static final Matchers SPACE_MATCHER = new CharMatcher(' ');
    private static final Matchers SPLIT_MATCHER = new CharSetMatcher(" \t\n\r\f".toCharArray());
    private static final Matchers TRIM_MATCHER = new TrimMatcher();
    private static final Matchers SINGLE_QUOTE_MATCHER = new CharMatcher('\'');
    private static final Matchers DOUBLE_QUOTE_MATCHER = new CharMatcher('\"');
    private static final Matchers QUOTE_MATCHER = new CharSetMatcher("'\"".toCharArray());
    private static final Matchers NONE_MATCHER = new NoMatcher();

    protected Matchers() {
    }

    public static Matchers commaMatcher() {
        return COMMA_MATCHER;
    }

    public static Matchers tabMatcher() {
        return TAB_MATCHER;
    }

    public static Matchers spaceMatcher() {
        return SPACE_MATCHER;
    }

    public static Matchers splitMatcher() {
        return SPLIT_MATCHER;
    }

    public static Matchers trimMatcher() {
        return TRIM_MATCHER;
    }

    public static Matchers singleQuoteMatcher() {
        return SINGLE_QUOTE_MATCHER;
    }

    public static Matchers doubleQuoteMatcher() {
        return DOUBLE_QUOTE_MATCHER;
    }

    public static Matchers quoteMatcher() {
        return QUOTE_MATCHER;
    }

    public static Matchers noneMatcher() {
        return NONE_MATCHER;
    }

    public static Matchers charMatcher(char ch) {
        return new CharMatcher(ch);
    }

    public static Matchers charSetMatcher(char ... chars) {
        if (null == chars || chars.length == 0) {
            return NONE_MATCHER;
        }
        if (chars.length == 1) {
            return new CharMatcher(chars[0]);
        }
        return new CharSetMatcher(chars);
    }

    public static Matchers charSetMatcher(String chars) {
        if (StringKit.isEmpty(chars)) {
            return NONE_MATCHER;
        }
        if (chars.length() == 1) {
            return new CharMatcher(chars.charAt(0));
        }
        return new CharSetMatcher(chars.toCharArray());
    }

    public static Matchers stringMatcher(String text) {
        if (StringKit.isEmpty(text)) {
            return NONE_MATCHER;
        }
        return new StringMatcher(text);
    }

    public abstract int isMatch(char[] var1, int var2, int var3, int var4);

    public int isMatch(char[] buffer, int pos) {
        return this.isMatch(buffer, pos, 0, buffer.length);
    }

    static final class TrimMatcher
    extends Matchers {
        TrimMatcher() {
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            return buffer[pos] <= ' ' ? 1 : 0;
        }
    }

    static final class NoMatcher
    extends Matchers {
        NoMatcher() {
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            return 0;
        }
    }

    static final class StringMatcher
    extends Matchers {
        private final char[] chars;

        StringMatcher(String text) {
            this.chars = text.toCharArray();
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            int len = this.chars.length;
            if (pos + len > bufferEnd) {
                return 0;
            }
            int i = 0;
            while (i < this.chars.length) {
                if (this.chars[i] != buffer[pos]) {
                    return 0;
                }
                ++i;
                ++pos;
            }
            return len;
        }

        public String toString() {
            return super.toString() + ' ' + Arrays.toString(this.chars);
        }
    }

    static final class CharMatcher
    extends Matchers {
        private final char ch;

        CharMatcher(char ch) {
            this.ch = ch;
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            return this.ch == buffer[pos] ? 1 : 0;
        }
    }

    static final class CharSetMatcher
    extends Matchers {
        private final char[] chars;

        CharSetMatcher(char[] chars) {
            this.chars = (char[])chars.clone();
            Arrays.sort(this.chars);
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            return Arrays.binarySearch(this.chars, buffer[pos]) >= 0 ? 1 : 0;
        }
    }
}

