/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.json.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.extra.json.provider.AbstractJsonProvider;

public class GsonProvider
extends AbstractJsonProvider {
    public static Gson gson;

    public GsonProvider() {
        gson = new GsonBuilder().registerTypeAdapter(new TypeToken<Map<Object, Object>>(){}.getType(), (jsonElement, type, jsonDeserializationContext) -> {
            LinkedHashMap map = new LinkedHashMap();
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                Object obj = entry.getValue();
                if (obj instanceof JsonPrimitive) {
                    map.put(entry.getKey(), ((JsonPrimitive)obj).getAsString());
                    continue;
                }
                map.put(entry.getKey(), (String)obj);
            }
            return map;
        }).registerTypeAdapter(new TypeToken<List<Object>>(){}.getType(), (jsonElement, type, jsonDeserializationContext) -> {
            LinkedList<JsonElement> list = new LinkedList<JsonElement>();
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (jsonArray.get(i).isJsonObject()) {
                    JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
                    Set entrySet = jsonObject.entrySet();
                    list.addAll(entrySet);
                    continue;
                }
                if (!jsonArray.get(i).isJsonPrimitive()) continue;
                list.add(jsonArray.get(i));
            }
            return list;
        }).create();
    }

    @Override
    public String toJsonString(Object object) {
        return gson.toJson(object);
    }

    @Override
    public String toJsonString(Object object, String format) {
        gson = new GsonBuilder().setDateFormat(format).create();
        return gson.toJson(object);
    }

    @Override
    public <T> T toPojo(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    @Override
    public <T> T toPojo(Map map, Class<T> clazz) {
        return (T)gson.fromJson(gson.toJson((Object)map), clazz);
    }

    @Override
    public <T> List<T> toList(String json) {
        TypeToken<List<Object>> typeToken = new TypeToken<List<Object>>(){};
        return (List)gson.fromJson(json, typeToken.getType());
    }

    @Override
    public <T> List<T> toList(String json, Class<T> clazz) {
        return (List)gson.fromJson(json, clazz);
    }

    @Override
    public <T> List<T> toList(String json, Type type) {
        return (List)gson.fromJson(json, type);
    }

    @Override
    public <K, V> Map<K, V> toMap(String json) {
        TypeToken<Map<Object, Object>> typeToken = new TypeToken<Map<Object, Object>>(){};
        return (Map)gson.fromJson(json, typeToken.getType());
    }

    @Override
    public <K, V> Map<K, V> toMap(Object object) {
        TypeToken<Map<Object, Object>> typeToken = new TypeToken<Map<Object, Object>>(){};
        return (Map)gson.fromJson(gson.toJson(object), typeToken.getType());
    }

    @Override
    public <T> T getValue(String json, String field) {
        return (T)JsonParser.parseString((String)json).getAsJsonObject().get(field);
    }

    @Override
    public boolean isJson(String json) {
        try {
            gson.fromJson(json, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }
}

