/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.pinyin.provider;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.extra.pinyin.provider.AbstractPinyinProvider;

public class Pinyin4JProvider
extends AbstractPinyinProvider {
    HanyuPinyinOutputFormat format;

    public Pinyin4JProvider() {
        this(null);
    }

    public Pinyin4JProvider(HanyuPinyinOutputFormat format) {
        this.init(format);
    }

    public void init(HanyuPinyinOutputFormat format) {
        if (null == format) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        String result;
        try {
            String[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            result = ArrayKit.isEmpty(results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            result = String.valueOf(c);
        }
        return result;
    }

    @Override
    public String getPinyin(String text, String separator) {
        TextBuilder result = new TextBuilder();
        boolean isFirst = true;
        int strLen = text.length();
        try {
            for (int i = 0; i < strLen; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append(separator);
                }
                String[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)text.charAt(i), (HanyuPinyinOutputFormat)this.format);
                if (ArrayKit.isEmpty(pinyinStringArray)) {
                    result.append(text.charAt(i));
                    continue;
                }
                result.append(pinyinStringArray[0]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new InstrumentException(e);
        }
        return result.toString();
    }
}

