/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.logger.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
public class PrimaryFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerWebExchange mutate = this.setDefaultContentTypeIfNecessary(exchange);
        Context context = Context.get(mutate);
        context.setStartTime(System.currentTimeMillis());
        ServerHttpRequest request = mutate.getRequest();
        if (Objects.equals(request.getMethod(), HttpMethod.GET)) {
            MultiValueMap params2 = request.getQueryParams();
            context.setRequestMap(params2.toSingleValueMap());
            this.doParams(mutate);
            return chain.filter(mutate).then(Mono.fromRunnable(() -> Logger.info("traceId:{},exec time :{} ms", mutate.getLogPrefix(), System.currentTimeMillis() - context.getStartTime())));
        }
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mutate.getRequest().getHeaders().getContentType())) {
            return mutate.getMultipartData().flatMap(params -> {
                LinkedHashMap<String, String> formMap = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Part> fileMap = new LinkedHashMap<String, Part>();
                Map map = params.toSingleValueMap();
                map.forEach((k, v) -> {
                    if (v instanceof FormFieldPart) {
                        formMap.put((String)k, ((FormFieldPart)v).value());
                    }
                    if (v instanceof FilePart) {
                        fileMap.put((String)k, (Part)v);
                    }
                });
                context.setRequestMap(formMap);
                context.setFilePartMap(fileMap);
                this.doParams(mutate);
                return chain.filter(mutate).doOnTerminate(() -> Logger.info("traceId:{},exec time :{}ms", mutate.getLogPrefix(), System.currentTimeMillis() - context.getStartTime()));
            });
        }
        return mutate.getFormData().flatMap(params -> {
            context.setRequestMap(params.toSingleValueMap());
            this.doParams(mutate);
            return chain.filter(mutate).doOnTerminate(() -> Logger.info("traceId:{},exec time :{}ms", mutate.getLogPrefix(), System.currentTimeMillis() - context.getStartTime()));
        });
    }

    private void doParams(ServerWebExchange exchange) {
        Context context = Context.get(exchange);
        Map<String, String> params = context.getRequestMap();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!"undefined".equals(StringKit.lowerCase(entry.getKey())) && !"undefined".equals(StringKit.lowerCase(entry.getValue()))) continue;
            throw new BusinessException(ErrorCode.EM_100101);
        }
        if (StringKit.isBlank(params.get("method"))) {
            throw new BusinessException(ErrorCode.EM_100108);
        }
        if (StringKit.isBlank(params.get("v"))) {
            throw new BusinessException(ErrorCode.EM_100107);
        }
        if (StringKit.isBlank(params.get("format"))) {
            throw new BusinessException(ErrorCode.EM_100111);
        }
        if (StringKit.isNotBlank(params.get("sign"))) {
            context.setNeedDecrypt(true);
        }
        Logger.info("traceId:{},method:{},req =>{}", exchange.getLogPrefix(), params.get("method"), JsonKit.toJsonString(context.getRequestMap()));
    }

    private ServerWebExchange setDefaultContentTypeIfNecessary(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        MediaType mediaType = request.getHeaders().getContentType();
        if (null == mediaType) {
            mediaType = MediaType.APPLICATION_FORM_URLENCODED;
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            headers.setContentType(mediaType);
            ServerHttpRequestDecorator requestDecorator = new ServerHttpRequestDecorator(request){

                public HttpHeaders getHeaders() {
                    return headers;
                }
            };
            return exchange.mutate().request((ServerHttpRequest)requestDecorator).build();
        }
        return exchange;
    }
}

