/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.builtin.hardware.VirtualMemory;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.hardware.LinuxVirtualMemory;

@ThreadSafe
public final class LinuxGlobalMemory
extends AbstractGlobalMemory {
    public static final long PAGE_SIZE = Builder.parseLongOrDefault(Executor.getFirstAnswer("getconf PAGE_SIZE"), 4096L);
    private final Supplier<Pair<Long, Long>> availTotal = Memoize.memoize(LinuxGlobalMemory::readMemInfo, Memoize.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoize.memoize(this::createVirtualMemory);

    private static Pair<Long, Long> readMemInfo() {
        long memFree = 0L;
        long activeFile = 0L;
        long inactiveFile = 0L;
        long sReclaimable = 0L;
        long memTotal = 0L;
        List<String> procMemInfo = Builder.readFile(ProcPath.MEMINFO);
        for (String checkLine : procMemInfo) {
            String[] memorySplit = RegEx.SPACES.split(checkLine, 2);
            if (memorySplit.length <= 1) continue;
            switch (memorySplit[0]) {
                case "MemTotal:": {
                    memTotal = Builder.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    break;
                }
                case "MemAvailable:": {
                    long memAvailable = Builder.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    return Pair.of(memAvailable, memTotal);
                }
                case "MemFree:": {
                    memFree = Builder.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    break;
                }
                case "Active(file):": {
                    activeFile = Builder.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    break;
                }
                case "Inactive(file):": {
                    inactiveFile = Builder.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    break;
                }
                case "SReclaimable:": {
                    sReclaimable = Builder.parseDecimalMemorySizeToBinary(memorySplit[1]);
                    break;
                }
            }
        }
        return Pair.of(memFree + activeFile + inactiveFile + sReclaimable, memTotal);
    }

    @Override
    public long getAvailable() {
        return this.availTotal.get().getLeft();
    }

    @Override
    public long getTotal() {
        return this.availTotal.get().getRight();
    }

    @Override
    public long getPageSize() {
        return PAGE_SIZE;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private VirtualMemory createVirtualMemory() {
        return new LinuxVirtualMemory(this);
    }
}

