/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;

@ThreadSafe
public final class NetStat {
    public static Pair<Long, Long> queryTcpnetstat() {
        long tcp4 = 0L;
        long tcp6 = 0L;
        List<String> activeConns = Executor.runNative("netstat -n -p tcp");
        for (String s : activeConns) {
            if (!s.endsWith("ESTABLISHED")) continue;
            if (s.startsWith("tcp4")) {
                ++tcp4;
                continue;
            }
            if (!s.startsWith("tcp6")) continue;
            ++tcp6;
        }
        return Pair.of(tcp4, tcp6);
    }

    public static List<InternetProtocolStats.IPConnection> queryNetstat() {
        ArrayList<InternetProtocolStats.IPConnection> connections = new ArrayList<InternetProtocolStats.IPConnection>();
        List<String> activeConns = Executor.runNative("netstat -n");
        for (String s : activeConns) {
            String state;
            String[] split = null;
            if (!s.startsWith("tcp") && !s.startsWith("udp") || (split = RegEx.SPACES.split(s)).length < 5) continue;
            String string = state = split.length == 6 ? split[5] : null;
            if ("SYN_RCVD".equals(state)) {
                state = "SYN_RECV";
            }
            String type = split[0];
            Pair<byte[], Integer> local = NetStat.parseIP(split[3]);
            Pair<byte[], Integer> foreign = NetStat.parseIP(split[4]);
            connections.add(new InternetProtocolStats.IPConnection(type, local.getLeft(), local.getRight(), foreign.getLeft(), foreign.getRight(), state == null ? InternetProtocolStats.TcpState.NONE : InternetProtocolStats.TcpState.valueOf(state), Builder.parseIntOrDefault(split[2], 0), Builder.parseIntOrDefault(split[1], 0), -1));
        }
        return connections;
    }

    private static Pair<byte[], Integer> parseIP(String s) {
        int portPos = s.lastIndexOf(46);
        if (portPos > 0 && s.length() > portPos) {
            int port = Builder.parseIntOrDefault(s.substring(portPos + 1), 0);
            String ip = s.substring(0, portPos);
            try {
                return Pair.of(InetAddress.getByName(ip).getAddress(), port);
            }
            catch (UnknownHostException e) {
                try {
                    ip = ip.endsWith(":") && ip.contains("::") ? ip + "0" : (ip.endsWith(":") || ip.contains("::") ? ip + ":0" : ip + "::0");
                    return Pair.of(InetAddress.getByName(ip).getAddress(), port);
                }
                catch (UnknownHostException e2) {
                    return Pair.of(new byte[0], port);
                }
            }
        }
        return Pair.of(new byte[0], 0);
    }

    public static InternetProtocolStats.TcpStats queryTcpStats(String netstatStr) {
        long connectionsEstablished = 0L;
        long connectionsActive = 0L;
        long connectionsPassive = 0L;
        long connectionFailures = 0L;
        long connectionsReset = 0L;
        long segmentsSent = 0L;
        long segmentsReceived = 0L;
        long segmentsRetransmitted = 0L;
        long inErrors = 0L;
        long outResets = 0L;
        List<String> netstat = Executor.runNative(netstatStr);
        block38: for (String s : netstat) {
            String[] split = s.trim().split(" ", 2);
            if (split.length != 2) continue;
            switch (split[1]) {
                case "connections established": 
                case "connection established (including accepts)": 
                case "connections established (including accepts)": {
                    connectionsEstablished = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "active connection openings": {
                    connectionsActive = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "passive connection openings": {
                    connectionsPassive = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "failed connection attempts": 
                case "bad connection attempts": {
                    connectionFailures = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "connection resets received": 
                case "dropped due to RST": {
                    connectionsReset = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "segments sent out": 
                case "packet sent": 
                case "packets sent": {
                    segmentsSent = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "segments received": 
                case "packet received": 
                case "packets received": {
                    segmentsReceived = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "segments retransmitted": {
                    segmentsRetransmitted = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "bad segments received": 
                case "discarded for bad checksum": 
                case "discarded for bad checksums": 
                case "discarded for bad header offset field": 
                case "discarded for bad header offset fields": 
                case "discarded because packet too short": 
                case "discarded for missing IPsec protection": {
                    inErrors += Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
                case "resets sent": {
                    outResets = Builder.parseLongOrDefault(split[0], 0L);
                    continue block38;
                }
            }
            if (!split[1].contains("retransmitted") || !split[1].contains("data packet")) continue;
            segmentsRetransmitted += Builder.parseLongOrDefault(split[0], 0L);
        }
        return new InternetProtocolStats.TcpStats(connectionsEstablished, connectionsActive, connectionsPassive, connectionFailures, connectionsReset, segmentsSent, segmentsReceived, segmentsRetransmitted, inErrors, outResets);
    }

    public static InternetProtocolStats.UdpStats queryUdpStats(String netstatStr) {
        long datagramsSent = 0L;
        long datagramsReceived = 0L;
        long datagramsNoPort = 0L;
        long datagramsReceivedErrors = 0L;
        List<String> netstat = Executor.runNative(netstatStr);
        for (String s : netstat) {
            String[] split = s.trim().split(" ", 2);
            if (split.length != 2) continue;
            switch (split[1]) {
                case "packets sent": 
                case "datagram output": 
                case "datagrams output": {
                    datagramsSent = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packets received": 
                case "datagram received": 
                case "datagrams received": {
                    datagramsReceived = Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packets to unknown port received": 
                case "dropped due to no socket": 
                case "broadcast/multicast datagram dropped due to no socket": 
                case "broadcast/multicast datagrams dropped due to no socket": {
                    datagramsNoPort += Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
                case "packet receive errors": 
                case "with incomplete header": 
                case "with bad data length field": 
                case "with bad checksum": 
                case "woth no checksum": {
                    datagramsReceivedErrors += Builder.parseLongOrDefault(split[0], 0L);
                    break;
                }
            }
        }
        return new InternetProtocolStats.UdpStats(datagramsSent, datagramsReceived, datagramsNoPort, datagramsReceivedErrors);
    }
}

