/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class Xrandr {
    private static final String[] XRANDR_VERBOSE = new String[]{"xrandr", "--verbose"};

    private Xrandr() {
    }

    public static List<byte[]> getEdidArrays() {
        List<String> xrandr = Executor.runNative(XRANDR_VERBOSE, null);
        if (xrandr.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> displays = new ArrayList<byte[]>();
        StringBuilder sb = null;
        for (String s : xrandr) {
            if (s.contains("EDID")) {
                sb = new StringBuilder();
                continue;
            }
            if (sb == null) continue;
            sb.append(s.trim());
            if (sb.length() < 256) continue;
            String edidStr = sb.toString();
            byte[] edid = Builder.hexStringToByteArray(edidStr);
            if (edid.length >= 128) {
                displays.add(edid);
            }
            sb = null;
        }
        return displays;
    }
}

