/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.drivers;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.unix.AixLibc;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class PsInfo {
    private static final AixLibc LIBC = AixLibc.INSTANCE;
    private static final long PAGE_SIZE = 4096L;

    public static AixLibc.AixPsInfo queryPsInfo(int pid) {
        Path path = Paths.get(String.format("/proc/%d/psinfo", pid), new String[0]);
        try {
            return new AixLibc.AixPsInfo(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static AixLibc.AIXLwpsInfo queryLwpsInfo(int pid, int tid) {
        Path path = Paths.get(String.format("/proc/%d/lwp/%d/lwpsinfo", pid, tid), new String[0]);
        try {
            return new AixLibc.AIXLwpsInfo(Files.readAllBytes(path));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Triple<Integer, Long, Long> queryArgsEnvAddrs(int pid, AixLibc.AixPsInfo psinfo) {
        if (psinfo != null) {
            int argc = psinfo.pr_argc;
            if (argc > 0) {
                long argv = psinfo.pr_argv;
                long envp = psinfo.pr_envp;
                return Triple.of(argc, argv, envp);
            }
            Logger.trace("Failed argc sanity check: argc={}", argc);
            return null;
        }
        Logger.trace("Failed to read psinfo file for pid: {} ", pid);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int pid, AixLibc.AixPsInfo psinfo) {
        ArrayList<String> args = new ArrayList<String>();
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        Triple<Integer, Long, Long> addrs = PsInfo.queryArgsEnvAddrs(pid, psinfo);
        if (addrs != null) {
            String procas = "/proc/" + pid + "/as";
            int fd = LIBC.open(procas, 0);
            if (fd < 0) {
                Logger.trace("No permission to read file: {} ", procas);
                return Pair.of(args, env);
            }
            try {
                long argp;
                long increment;
                int argc = addrs.getLeft();
                long argv = addrs.getMiddle();
                long envp = addrs.getRight();
                Path p = Paths.get("/proc/" + pid + "/status", new String[0]);
                try {
                    byte[] status = Files.readAllBytes(p);
                    increment = status[17] == 1 ? 8L : 4L;
                }
                catch (IOException e) {
                    Pair<List<String>, Map<String, String>> pair = Pair.of(args, env);
                    LIBC.close(fd);
                    return pair;
                }
                Memory buffer = new Memory(8192L);
                LibCAPI.size_t bufSize = new LibCAPI.size_t(buffer.size());
                long bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, 0L, argv);
                long[] argPtr = new long[argc];
                long l = argp = bufStart == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, argv - bufStart, increment);
                if (argp > 0L) {
                    for (int i = 0; i < argc; ++i) {
                        long offset = argp + (long)i * increment;
                        argPtr[i] = (bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, offset)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, offset - bufStart, increment);
                    }
                }
                bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, envp);
                ArrayList<Long> envPtrList = new ArrayList<Long>();
                long addr = bufStart == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, envp - bufStart, increment);
                int limit = 500;
                long offset = addr;
                while (addr != 0L && --limit > 0) {
                    long envPtr;
                    long l2 = envPtr = (bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, offset)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(buffer, offset - bufStart, increment);
                    if (envPtr != 0L) {
                        envPtrList.add(envPtr);
                    }
                    offset += increment;
                }
                for (int i = 0; i < argPtr.length && argPtr[i] != 0L; ++i) {
                    String argStr;
                    if ((bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, argPtr[i])) == 0L || (argStr = buffer.getString(argPtr[i] - bufStart)).isEmpty()) continue;
                    args.add(argStr);
                }
                for (Long envPtr : envPtrList) {
                    String envStr;
                    int idx;
                    if ((bufStart = PsInfo.conditionallyReadBufferFromStartOfPage(fd, buffer, bufSize, bufStart, envPtr)) == 0L || (idx = (envStr = buffer.getString(envPtr - bufStart)).indexOf(61)) <= 0) continue;
                    env.put(envStr.substring(0, idx), envStr.substring(idx + 1));
                }
            }
            finally {
                LIBC.close(fd);
            }
        }
        return Pair.of(args, env);
    }

    private static long conditionallyReadBufferFromStartOfPage(int fd, Memory buffer, LibCAPI.size_t bufSize, long bufStart, long addr) {
        if (addr < bufStart || addr - bufStart > 4096L) {
            long newStart = Math.floorDiv(addr, 4096L) * 4096L;
            LibCAPI.ssize_t result = LIBC.pread(fd, (Pointer)buffer, bufSize, new NativeLong(newStart));
            if (result.longValue() < 4096L) {
                Logger.debug("Failed to read page from address space: {} bytes read", result.longValue());
                return 0L;
            }
            return newStart;
        }
        return bufStart;
    }

    private static long getOffsetFromBuffer(Memory buffer, long offset, long increment) {
        return increment == 8L ? buffer.getLong(offset) : (long)buffer.getInt(offset);
    }
}

