/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.drivers.disk;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class GeomDiskList {
    private static final String GEOM_DISK_LIST = "geom disk list";

    public static Map<String, Triple<String, String, Long>> queryDisks() {
        HashMap<String, Triple<String, String, Long>> diskMap = new HashMap<String, Triple<String, String, Long>>();
        String diskName = null;
        String descr = "unknown";
        String ident = "unknown";
        long mediaSize = 0L;
        List<String> geom = Executor.runNative(GEOM_DISK_LIST);
        for (String line : geom) {
            String[] split;
            if ((line = line.trim()).startsWith("Geom name:")) {
                if (diskName != null) {
                    diskMap.put(diskName, Triple.of(descr, ident, mediaSize));
                    descr = "unknown";
                    ident = "unknown";
                    mediaSize = 0L;
                }
                diskName = line.substring(line.lastIndexOf(32) + 1);
            }
            if (diskName == null) continue;
            if ((line = line.trim()).startsWith("Mediasize:") && (split = RegEx.SPACES.split(line)).length > 1) {
                mediaSize = Builder.parseLongOrDefault(split[1], 0L);
            }
            if (line.startsWith("descr:")) {
                descr = line.replace("descr:", "").trim();
            }
            if (!line.startsWith("ident:")) continue;
            ident = line.replace("ident:", "").replace("(null)", "").trim();
        }
        if (diskName != null) {
            diskMap.put(diskName, Triple.of(descr, ident, mediaSize));
        }
        return diskMap;
    }
}

