/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.software;

import java.io.File;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.unix.openbsd.OpenBsdSysctlKit;
import org.aoju.bus.health.unix.openbsd.software.OpenBsdOSFileStore;

@ThreadSafe
public class OpenBsdFileSystem
extends AbstractFileSystem {
    public static final String OPENBSD_FS_PATH_EXCLUDES = "bus.health.os.openbsd.filesystem.path.excludes";
    public static final String OPENBSD_FS_PATH_INCLUDES = "bus.health.os.openbsd.filesystem.path.includes";
    public static final String OPENBSD_FS_VOLUME_EXCLUDES = "bus.health.os.openbsd.filesystem.volume.excludes";
    public static final String OPENBSD_FS_VOLUME_INCLUDES = "bus.health.os.openbsd.filesystem.volume.includes";
    private static final List<PathMatcher> FS_PATH_EXCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.openbsd.filesystem.path.excludes");
    private static final List<PathMatcher> FS_PATH_INCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.openbsd.filesystem.path.includes");
    private static final List<PathMatcher> FS_VOLUME_EXCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.openbsd.filesystem.volume.excludes");
    private static final List<PathMatcher> FS_VOLUME_INCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.openbsd.filesystem.volume.includes");

    static List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        return OpenBsdFileSystem.getFileStoreMatching(nameToMatch, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, boolean localOnly) {
        String[] split;
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeUsedlMap = new HashMap<String, Long>();
        String command = "df -i" + (localOnly ? " -l" : "");
        for (String line : Executor.runNative(command)) {
            if (!line.startsWith("/") || (split = RegEx.SPACES.split(line)).length <= 6) continue;
            inodeUsedlMap.put(split[0], Builder.parseLongOrDefault(split[5], 0L));
            inodeFreeMap.put(split[0], Builder.parseLongOrDefault(split[6], 0L));
        }
        for (String fs : Executor.runNative("mount -v")) {
            split = RegEx.SPACES.split(fs, 7);
            if (split.length != 7) continue;
            String volume = split[0];
            String uuid = split[1];
            String path = split[3];
            String type = split[5];
            String options = split[6];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || !path.equals("/") && (PSEUDO_FS_TYPES.contains(type) || Builder.isFileStoreExcluded(path, volume, FS_PATH_INCLUDES, FS_PATH_EXCLUDES, FS_VOLUME_INCLUDES, FS_VOLUME_EXCLUDES))) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk (dynamic)" : (volume.equals("mfs") ? "Ram Disk (fixed)" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point")));
            fsList.add(new OpenBsdOSFileStore(name, volume, name, path, options, uuid, "", description, type, freeSpace, usableSpace, totalSpace, inodeFreeMap.getOrDefault(volume, 0L), inodeUsedlMap.getOrDefault(volume, 0L) + inodeFreeMap.getOrDefault(volume, 0L)));
        }
        return fsList;
    }

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        return OpenBsdFileSystem.getFileStoreMatching(null, localOnly);
    }

    @Override
    public long getOpenFileDescriptors() {
        return OpenBsdSysctlKit.sysctl("kern.nfiles", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return OpenBsdSysctlKit.sysctl("kern.maxfiles", 0);
    }
}

