/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.drivers.kstat;

import com.sun.jna.platform.unix.solaris.LibKstat;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.unix.solaris.KstatKit;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;

@ThreadSafe
public final class SystemPages {
    public static Pair<Long, Long> queryAvailableTotal() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SystemPages.queryAvailableTotal2();
        }
        long memAvailable = 0L;
        long memTotal = 0L;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup(null, -1, "system_pages");
            if (ksp != null && KstatKit.KstatChain.read(ksp)) {
                memAvailable = KstatKit.dataLookupLong(ksp, "availrmem");
                memTotal = KstatKit.dataLookupLong(ksp, "physmem");
            }
        }
        return Pair.of(memAvailable, memTotal);
    }

    private static Pair<Long, Long> queryAvailableTotal2() {
        Object[] results = KstatKit.queryKstat2("kstat:/pages/unix/system_pages", "availrmem", "physmem");
        long avail = results[0] == null ? 0L : (Long)results[0];
        long total = results[1] == null ? 0L : (Long)results[1];
        return Pair.of(avail, total);
    }
}

