/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.unix.SolarisLibc;
import org.aoju.bus.health.unix.solaris.KstatKit;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;

@ThreadSafe
final class SolarisCentralProcessor
extends AbstractCentralProcessor {
    private static final String KSTAT_SYSTEM_CPU = "kstat:/system/cpu/";
    private static final String INFO = "/info";
    private static final String SYS = "/sys";
    private static final String KSTAT_PM_CPU = "kstat:/pm/cpu/";
    private static final String PSTATE = "/pstate";
    private static final String CPU_INFO = "cpu_info";

    SolarisCentralProcessor() {
    }

    private static CentralProcessor.ProcessorIdentifier queryProcessorId2(boolean cpu64bit) {
        Object[] results = KstatKit.queryKstat2("kstat:/system/cpu/0/info", "vendor_id", "brand", "family", "model", "stepping", "clock_MHz");
        String cpuVendor = results[0] == null ? "" : (String)results[0];
        String cpuName = results[1] == null ? "" : (String)results[1];
        String cpuFamily = results[2] == null ? "" : results[2].toString();
        String cpuModel = results[3] == null ? "" : results[3].toString();
        String cpuStepping = results[4] == null ? "" : results[4].toString();
        long cpuFreq = results[5] == null ? 0L : (Long)results[5];
        String processorID = SolarisCentralProcessor.getProcessorID(cpuStepping, cpuModel, cpuFamily);
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    private static List<CentralProcessor.LogicalProcessor> initProcessorCounts2(Map<Integer, Integer> numaNodeMap) {
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        List<Object[]> results = KstatKit.queryKstat2List(KSTAT_SYSTEM_CPU, INFO, "chip_id", "core_id");
        for (Object[] result : results) {
            int procId = logProcs.size();
            long chipId = result[0] == null ? 0L : (Long)result[0];
            long coreId = result[1] == null ? 0L : (Long)result[1];
            CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(procId, (int)coreId, (int)chipId, numaNodeMap.getOrDefault(procId, 0));
            logProcs.add(logProc);
        }
        if (logProcs.isEmpty()) {
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        return logProcs;
    }

    private static Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> numaNodeMap = new HashMap<Integer, Integer>();
        int lgroup = 0;
        for (String line : Executor.runNative("lgrpinfo -c leaves")) {
            if (line.startsWith("lgroup")) {
                lgroup = Builder.getFirstIntValue(line);
                continue;
            }
            if (!line.contains("CPUs:") && !line.contains("CPU:")) continue;
            for (Integer cpu : Builder.parseHyphenatedIntList(line.split(":")[1])) {
                numaNodeMap.put(cpu, lgroup);
            }
        }
        return numaNodeMap;
    }

    private static long[] queryCurrentFreq2(int processorCount) {
        long[] freqs = new long[processorCount];
        Arrays.fill(freqs, -1L);
        List<Object[]> results = KstatKit.queryKstat2List(KSTAT_SYSTEM_CPU, INFO, "current_clock_Hz");
        int cpu = -1;
        for (Object[] result : results) {
            if (++cpu >= freqs.length) break;
            freqs[cpu] = result[0] == null ? -1L : (Long)result[0];
        }
        return freqs;
    }

    private static long queryMaxFreq2() {
        long max = -1L;
        List<Object[]> results = KstatKit.queryKstat2List(KSTAT_PM_CPU, PSTATE, "supported_frequencies");
        for (Object[] result : results) {
            for (long freq : result[0] == null ? new long[]{} : (long[])result[0]) {
                if (freq <= max) continue;
                max = freq;
            }
        }
        return max;
    }

    private static long[][] queryProcessorCpuLoadTicks2(int processorCount) {
        long[][] ticks = new long[processorCount][CentralProcessor.TickType.values().length];
        List<Object[]> results = KstatKit.queryKstat2List(KSTAT_SYSTEM_CPU, SYS, "cpu_ticks_idle", "cpu_ticks_kernel", "cpu_ticks_user");
        int cpu = -1;
        for (Object[] result : results) {
            if (++cpu >= ticks.length) break;
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = result[0] == null ? 0L : (Long)result[0];
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = result[1] == null ? 0L : (Long)result[1];
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = result[2] == null ? 0L : (Long)result[2];
        }
        return ticks;
    }

    private static String getProcessorID(String stepping, String model, String family) {
        List<String> isainfo = Executor.runNative("isainfo -v");
        StringBuilder flags = new StringBuilder();
        for (String line : isainfo) {
            if (line.startsWith("32-bit")) break;
            if (line.startsWith("64-bit")) continue;
            flags.append(' ').append(line.trim());
        }
        return SolarisCentralProcessor.createProcessorID(stepping, model, family, RegEx.SPACES.split(flags.toString().toLowerCase()));
    }

    private static long queryContextSwitches2() {
        long swtch = 0L;
        List<Object[]> results = KstatKit.queryKstat2List(KSTAT_SYSTEM_CPU, SYS, "pswitch", "inv_swtch");
        for (Object[] result : results) {
            swtch += result[0] == null ? 0L : (Long)result[0];
            swtch += result[1] == null ? 0L : (Long)result[1];
        }
        return swtch;
    }

    private static long queryInterrupts2() {
        long intr = 0L;
        List<Object[]> results = KstatKit.queryKstat2List(KSTAT_SYSTEM_CPU, SYS, "intr");
        for (Object[] result : results) {
            intr += result[0] == null ? 0L : (Long)result[0];
        }
        return intr;
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        boolean cpu64bit = "64".equals(Executor.getFirstAnswer("isainfo -b").trim());
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SolarisCentralProcessor.queryProcessorId2(cpu64bit);
        }
        String cpuVendor = "";
        String cpuName = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuFreq = 0L;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup(CPU_INFO, -1, null);
            if (ksp != null && KstatKit.KstatChain.read(ksp)) {
                cpuVendor = KstatKit.dataLookupString(ksp, "vendor_id");
                cpuName = KstatKit.dataLookupString(ksp, "brand");
                cpuFamily = KstatKit.dataLookupString(ksp, "family");
                cpuModel = KstatKit.dataLookupString(ksp, "model");
                cpuStepping = KstatKit.dataLookupString(ksp, "stepping");
                cpuFreq = KstatKit.dataLookupLong(ksp, "clock_MHz") * 1000000L;
            }
        }
        String processorID = SolarisCentralProcessor.getProcessorID(cpuStepping, cpuModel, cpuFamily);
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    @Override
    protected Pair<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>> initProcessorCounts() {
        Map<Integer, Integer> numaNodeMap = SolarisCentralProcessor.mapNumaNodes();
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return Pair.of(SolarisCentralProcessor.initProcessorCounts2(numaNodeMap), null);
        }
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            List<LibKstat.Kstat> kstats = KstatKit.KstatChain.lookupAll(CPU_INFO, -1, null);
            for (LibKstat.Kstat ksp : kstats) {
                if (ksp == null || !KstatKit.KstatChain.read(ksp)) continue;
                int procId = logProcs.size();
                String chipId = KstatKit.dataLookupString(ksp, "chip_id");
                String coreId = KstatKit.dataLookupString(ksp, "core_id");
                CentralProcessor.LogicalProcessor logProc = new CentralProcessor.LogicalProcessor(procId, Builder.parseIntOrDefault(coreId, 0), Builder.parseIntOrDefault(chipId, 0), numaNodeMap.getOrDefault(procId, 0));
                logProcs.add(logProc);
            }
        }
        if (logProcs.isEmpty()) {
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
        }
        HashMap<Integer, String> dmesg = new HashMap<Integer, String>();
        Pattern p = Pattern.compile(".* cpu(\\\\d+): ((ARM|AMD|Intel).+)");
        for (String s : Executor.runNative("dmesg")) {
            Matcher m = p.matcher(s);
            if (!m.matches()) continue;
            int coreId = Builder.parseIntOrDefault(m.group(1), 0);
            dmesg.put(coreId, m.group(2).trim());
        }
        if (dmesg.isEmpty()) {
            return Pair.of(logProcs, null);
        }
        return Pair.of(logProcs, this.createProcListFromDmesg(logProcs, dmesg));
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        int i = 0;
        while (i < ticks.length) {
            for (long[] procTick : procTicks) {
                int n = i;
                ticks[n] = ticks[n] + procTick[i];
            }
            int n = i++;
            ticks[n] = ticks[n] / (long)procTicks.length;
        }
        return ticks;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SolarisCentralProcessor.queryCurrentFreq2(this.getLogicalProcessorCount());
        }
        long[] freqs = new long[this.getLogicalProcessorCount()];
        Arrays.fill(freqs, -1L);
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            for (int i = 0; i < freqs.length; ++i) {
                for (LibKstat.Kstat ksp : KstatKit.KstatChain.lookupAll(CPU_INFO, i, null)) {
                    if (!KstatKit.KstatChain.read(ksp)) continue;
                    freqs[i] = KstatKit.dataLookupLong(ksp, "current_clock_Hz");
                }
            }
        }
        return freqs;
    }

    @Override
    public long queryMaxFreq() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SolarisCentralProcessor.queryMaxFreq2();
        }
        long max = -1L;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            for (LibKstat.Kstat ksp : KstatKit.KstatChain.lookupAll(CPU_INFO, 0, null)) {
                String suppFreq;
                if (!KstatKit.KstatChain.read(ksp) || (suppFreq = KstatKit.dataLookupString(ksp, "supported_frequencies_Hz")).isEmpty()) continue;
                for (String s : suppFreq.split(":")) {
                    long freq = Builder.parseLongOrDefault(s, -1L);
                    if (max >= freq) continue;
                    max = freq;
                }
            }
        }
        return max;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = SolarisLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SolarisCentralProcessor.queryProcessorCpuLoadTicks2(this.getLogicalProcessorCount());
        }
        long[][] ticks = new long[this.getLogicalProcessorCount()][CentralProcessor.TickType.values().length];
        int cpu = -1;
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            for (LibKstat.Kstat ksp : KstatKit.KstatChain.lookupAll("cpu", -1, "sys")) {
                if (++cpu >= ticks.length) {
                    break;
                }
                if (!KstatKit.KstatChain.read(ksp)) continue;
                ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = KstatKit.dataLookupLong(ksp, "cpu_ticks_idle");
                ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = KstatKit.dataLookupLong(ksp, "cpu_ticks_kernel");
                ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = KstatKit.dataLookupLong(ksp, "cpu_ticks_user");
            }
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SolarisCentralProcessor.queryContextSwitches2();
        }
        long swtch = 0L;
        List<String> kstat = Executor.runNative("kstat -p cpu_stat:::/pswitch\\\\|inv_swtch/");
        for (String s : kstat) {
            swtch += Builder.parseLastLong(s, 0L);
        }
        return swtch;
    }

    @Override
    public long queryInterrupts() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return SolarisCentralProcessor.queryInterrupts2();
        }
        long intr = 0L;
        List<String> kstat = Executor.runNative("kstat -p cpu_stat:::/intr/");
        for (String s : kstat) {
            intr += Builder.parseLastLong(s, 0L);
        }
        return intr;
    }
}

