/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractNetworkIF;
import org.aoju.bus.health.builtin.hardware.NetworkIF;
import org.aoju.bus.health.unix.solaris.KstatKit;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class SolarisNetworkIF
extends AbstractNetworkIF {
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long inDrops;
    private long collisions;
    private long speed;
    private long timeStamp;

    public SolarisNetworkIF(NetworkInterface netint) throws InstantiationException {
        super(netint);
        this.updateAttributes();
    }

    public static List<NetworkIF> getNetworks(boolean includeLocalInterfaces) {
        ArrayList<NetworkIF> ifList = new ArrayList<NetworkIF>();
        for (NetworkInterface ni : SolarisNetworkIF.getNetworkInterfaces(includeLocalInterfaces)) {
            try {
                ifList.add(new SolarisNetworkIF(ni));
            }
            catch (InstantiationException e) {
                Logger.debug("Network Interface Instantiation failed: {}", e.getMessage());
            }
        }
        return ifList;
    }

    @Override
    public long getBytesRecv() {
        return this.bytesRecv;
    }

    @Override
    public long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    @Override
    public long getPacketsSent() {
        return this.packetsSent;
    }

    @Override
    public long getInErrors() {
        return this.inErrors;
    }

    @Override
    public long getOutErrors() {
        return this.outErrors;
    }

    @Override
    public long getInDrops() {
        return this.inDrops;
    }

    @Override
    public long getCollisions() {
        return this.collisions;
    }

    @Override
    public long getSpeed() {
        return this.speed;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean updateAttributes() {
        this.timeStamp = System.currentTimeMillis();
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return this.updateAttributes2();
        }
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup("link", -1, this.getName());
            if (ksp == null) {
                ksp = KstatKit.KstatChain.lookup(null, -1, this.getName());
            }
            if (ksp != null && KstatKit.KstatChain.read(ksp)) {
                this.bytesSent = KstatKit.dataLookupLong(ksp, "obytes64");
                this.bytesRecv = KstatKit.dataLookupLong(ksp, "rbytes64");
                this.packetsSent = KstatKit.dataLookupLong(ksp, "opackets64");
                this.packetsRecv = KstatKit.dataLookupLong(ksp, "ipackets64");
                this.outErrors = KstatKit.dataLookupLong(ksp, "oerrors");
                this.inErrors = KstatKit.dataLookupLong(ksp, "ierrors");
                this.collisions = KstatKit.dataLookupLong(ksp, "collisions");
                this.inDrops = KstatKit.dataLookupLong(ksp, "dl_idrops");
                this.speed = KstatKit.dataLookupLong(ksp, "ifspeed");
                this.timeStamp = ksp.ks_snaptime / 1000000L;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean updateAttributes2() {
        Object[] results = KstatKit.queryKstat2("kstat:/net/link/" + this.getName() + "/0", "obytes64", "rbytes64", "opackets64", "ipackets64", "oerrors", "ierrors", "collisions", "dl_idrops", "ifspeed", "snaptime");
        if (results[results.length - 1] == null) {
            return false;
        }
        this.bytesSent = results[0] == null ? 0L : (Long)results[0];
        this.bytesRecv = results[1] == null ? 0L : (Long)results[1];
        this.packetsSent = results[2] == null ? 0L : (Long)results[2];
        this.packetsRecv = results[3] == null ? 0L : (Long)results[3];
        this.outErrors = results[4] == null ? 0L : (Long)results[4];
        this.collisions = results[5] == null ? 0L : (Long)results[5];
        this.inDrops = results[6] == null ? 0L : (Long)results[6];
        this.speed = results[7] == null ? 0L : (Long)results[7];
        this.timeStamp = (Long)results[8] / 1000000L;
        return true;
    }
}

