/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.unix.solaris.KstatKit;
import org.aoju.bus.health.unix.solaris.software.SolarisOSFileStore;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;

@ThreadSafe
public class SolarisFileSystem
extends AbstractFileSystem {
    public static final String SOLARIS_FS_PATH_EXCLUDES = "bus.health.os.solaris.filesystem.path.excludes";
    public static final String SOLARIS_FS_PATH_INCLUDES = "bus.health.os.solaris.filesystem.path.includes";
    public static final String SOLARIS_FS_VOLUME_EXCLUDES = "bus.health.os.solaris.filesystem.volume.excludes";
    public static final String SOLARIS_FS_VOLUME_INCLUDES = "bus.health.os.solaris.filesystem.volume.includes";
    private static final Supplier<Pair<Long, Long>> FILE_DESC = Memoize.memoize(SolarisFileSystem::queryFileDescriptors, Memoize.defaultExpiration());
    private static final List<PathMatcher> FS_PATH_EXCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.solaris.filesystem.path.excludes");
    private static final List<PathMatcher> FS_PATH_INCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.solaris.filesystem.path.includes");
    private static final List<PathMatcher> FS_VOLUME_EXCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.solaris.filesystem.volume.excludes");
    private static final List<PathMatcher> FS_VOLUME_INCLUDES = Builder.loadAndParseFileSystemConfig("bus.health.os.solaris.filesystem.volume.includes");

    static List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        return SolarisFileSystem.getFileStoreMatching(nameToMatch, false);
    }

    private static List<OSFileStore> getFileStoreMatching(String nameToMatch, boolean localOnly) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        String key = null;
        String total = null;
        String free = null;
        String command = "df -g" + (localOnly ? " -l" : "");
        for (String line : Executor.runNative(command)) {
            if (line.startsWith("/")) {
                key = RegEx.SPACES.split(line)[0];
                total = null;
                continue;
            }
            if (line.contains("available") && line.contains("total files")) {
                total = Builder.getTextBetweenStrings(line, "available", "total files").trim();
                continue;
            }
            if (!line.contains("free files")) continue;
            free = Builder.getTextBetweenStrings(line, "", "free files").trim();
            if (key == null || total == null) continue;
            inodeFreeMap.put(key, Builder.parseLongOrDefault(free, 0L));
            inodeTotalMap.put(key, Builder.parseLongOrDefault(total, 0L));
            key = null;
        }
        for (String fs : Executor.runNative("cat /etc/mnttab")) {
            String[] split = RegEx.SPACES.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            String options = split[3];
            if (localOnly && NETWORK_FS_TYPES.contains(type) || !path.equals("/") && (PSEUDO_FS_TYPES.contains(type) || Builder.isFileStoreExcluded(path, volume, FS_PATH_INCLUDES, FS_PATH_EXCLUDES, FS_VOLUME_INCLUDES, FS_VOLUME_EXCLUDES))) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            if (nameToMatch != null && !nameToMatch.equals(name)) continue;
            File f = new File(path);
            long totalSpace = f.getTotalSpace();
            long usableSpace = f.getUsableSpace();
            long freeSpace = f.getFreeSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (NETWORK_FS_TYPES.contains(type) ? "Network Disk" : "Mount Point"));
            fsList.add(new SolarisOSFileStore(name, volume, name, path, options, "", "", description, type, freeSpace, usableSpace, totalSpace, inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L, inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L));
        }
        return fsList;
    }

    private static Pair<Long, Long> queryFileDescriptors() {
        Object[] results = KstatKit.queryKstat2("kstat:/kmem_cache/kmem_default/file_cache", "buf_inuse", "buf_max");
        long inuse = results[0] == null ? 0L : (Long)results[0];
        long max = results[1] == null ? 0L : (Long)results[1];
        return Pair.of(inuse, max);
    }

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        return SolarisFileSystem.getFileStoreMatching(null, localOnly);
    }

    @Override
    public long getOpenFileDescriptors() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return FILE_DESC.get().getLeft();
        }
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup(null, -1, "file_cache");
            if (ksp != null && KstatKit.KstatChain.read(ksp)) {
                long l = KstatKit.dataLookupLong(ksp, "buf_inuse");
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long getMaxFileDescriptors() {
        if (SolarisOperatingSystem.IS_11_4_OR_HIGHER) {
            return FILE_DESC.get().getRight();
        }
        try (KstatKit.KstatChain kc = KstatKit.openChain();){
            LibKstat.Kstat ksp = KstatKit.KstatChain.lookup(null, -1, "file_cache");
            if (ksp != null && KstatKit.KstatChain.read(ksp)) {
                long l = KstatKit.dataLookupLong(ksp, "buf_max");
                return l;
            }
        }
        return 0L;
    }
}

