/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.software;

import com.sun.jna.Native;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractNetworkParams;
import org.aoju.bus.health.unix.SolarisLibc;

@ThreadSafe
final class SolarisNetworkParams
extends AbstractNetworkParams {
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;

    SolarisNetworkParams() {
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString((byte[])hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return SolarisNetworkParams.searchGateway(Executor.runNative("route get -inet default"));
    }

    @Override
    public String getIpv6DefaultGateway() {
        return SolarisNetworkParams.searchGateway(Executor.runNative("route get -inet6 default"));
    }
}

