/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinReg;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.windows.PowrProf;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.LogicalProcessorInformation;
import org.aoju.bus.health.windows.drivers.perfmon.ProcessorInformation;
import org.aoju.bus.health.windows.drivers.perfmon.SystemInformation;
import org.aoju.bus.health.windows.drivers.wmi.Win32Processor;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class WindowsCentralProcessor
extends AbstractCentralProcessor {
    private Map<String, Integer> numaNodeProcToLogicalProcMap;
    private long[] systicks = null;
    private long[] idleticks = null;
    private long[] elapsedticks = null;
    private long[] privticks = null;
    private long[] procticks = null;
    private long[] baseticks = null;

    WindowsCentralProcessor() {
        if (ProcessorInformation.USE_CPU_UTILITY) {
            Pair<List<String>, Map<ProcessorInformation.ProcessorCapacityTickCountProperty, List<Long>>> initialTicks = ProcessorInformation.queryInitialProcessorCapacityCounters();
            List<String> instances = initialTicks.getLeft();
            Map<ProcessorInformation.ProcessorCapacityTickCountProperty, List<Long>> valueMap = initialTicks.getRight();
            List<Long> systemList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPRIVILEGEDTIME);
            List<Long> userList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTUSERTIME);
            List<Long> idleList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPROCESSORTIME);
            List<Long> systemUtility = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPRIVILEGEDUTILITY);
            List<Long> processorUtility = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPROCESSORUTILITY);
            List<Long> processorUtilityBase = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPROCESSORUTILITY_BASE);
            int ncpu = this.getLogicalProcessorCount();
            this.systicks = new long[ncpu];
            this.idleticks = new long[ncpu];
            this.elapsedticks = new long[ncpu];
            this.privticks = new long[ncpu];
            this.procticks = new long[ncpu];
            this.baseticks = new long[ncpu];
            for (int p = 0; p < instances.size(); ++p) {
                int cpu;
                int n = cpu = instances.get(p).contains(",") ? this.numaNodeProcToLogicalProcMap.getOrDefault(instances.get(p), 0) : Builder.parseIntOrDefault(instances.get(p), 0);
                if (cpu >= ncpu) continue;
                this.systicks[cpu] = systemList.get(p);
                this.idleticks[cpu] = idleList.get(p);
                this.elapsedticks[cpu] = userList.get(p) + this.idleticks[cpu] + this.systicks[cpu];
                this.privticks[cpu] = systemUtility.get(p);
                this.procticks[cpu] = processorUtility.get(p);
                this.baseticks[cpu] = processorUtilityBase.get(p);
            }
        }
    }

    private static String parseIdentifier(String identifier, String key) {
        String[] idSplit = RegEx.SPACES.split(identifier);
        boolean found = false;
        for (String s : idSplit) {
            if (found) {
                return s;
            }
            found = s.equals(key);
        }
        return "";
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String processorID;
        WbemcliUtil.WmiResult<Win32Processor.ProcessorIdProperty> processorId;
        String cpuVendor = "";
        String cpuName = "";
        String cpuIdentifier = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuVendorFreq = 0L;
        boolean cpu64bit = false;
        String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\";
        String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\");
        if (processorIds.length > 0) {
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorIds[0];
            cpuVendor = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"VendorIdentifier");
            cpuName = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString");
            cpuIdentifier = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"Identifier");
            try {
                cpuVendorFreq = (long)Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"~MHz") * 1000000L;
            }
            catch (Win32Exception win32Exception) {
                // empty catch block
            }
        }
        if (!cpuIdentifier.isEmpty()) {
            cpuFamily = WindowsCentralProcessor.parseIdentifier(cpuIdentifier, "Family");
            cpuModel = WindowsCentralProcessor.parseIdentifier(cpuIdentifier, "Model");
            cpuStepping = WindowsCentralProcessor.parseIdentifier(cpuIdentifier, "Stepping");
        }
        WinBase.SYSTEM_INFO sysinfo = new WinBase.SYSTEM_INFO();
        Kernel32.INSTANCE.GetNativeSystemInfo(sysinfo);
        int processorArchitecture = sysinfo.processorArchitecture.pi.wProcessorArchitecture.intValue();
        if (processorArchitecture == 9 || processorArchitecture == 12 || processorArchitecture == 6) {
            cpu64bit = true;
        }
        if ((processorId = Win32Processor.queryProcessorId()).getResultCount() > 0) {
            processorID = WmiKit.getString(processorId, Win32Processor.ProcessorIdProperty.PROCESSORID, 0);
        } else {
            String[] stringArray;
            if (cpu64bit) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "ia64";
            } else {
                stringArray = new String[]{};
            }
            processorID = WindowsCentralProcessor.createProcessorID(cpuStepping, cpuModel, cpuFamily, stringArray);
        }
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuVendorFreq);
    }

    @Override
    protected Pair<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>> initProcessorCounts() {
        if (VersionHelpers.IsWindows7OrGreater()) {
            Pair<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>> procs = LogicalProcessorInformation.getLogicalProcessorInformationEx();
            int curNode = -1;
            int procNum = 0;
            int lp = 0;
            this.numaNodeProcToLogicalProcMap = new HashMap<String, Integer>();
            for (CentralProcessor.LogicalProcessor logProc : procs.getLeft()) {
                int node = logProc.getNumaNode();
                if (node != curNode) {
                    curNode = node;
                    procNum = 0;
                }
                this.numaNodeProcToLogicalProcMap.put(String.format("%d,%d", logProc.getNumaNode(), procNum++), lp++);
            }
            return procs;
        }
        return LogicalProcessorInformation.getLogicalProcessorInformation();
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        long[][] procTicks = this.getProcessorCpuLoadTicks();
        for (int i = 0; i < ticks.length; ++i) {
            for (long[] procTick : procTicks) {
                int n = i;
                ticks[n] = ticks[n] + procTick[i];
            }
        }
        return ticks;
    }

    @Override
    public long[] queryCurrentFreq() {
        if (VersionHelpers.IsWindows7OrGreater()) {
            Pair<List<String>, Map<ProcessorInformation.ProcessorFrequencyProperty, List<Long>>> instanceValuePair = ProcessorInformation.queryFrequencyCounters();
            List<String> instances = instanceValuePair.getLeft();
            Map<ProcessorInformation.ProcessorFrequencyProperty, List<Long>> valueMap = instanceValuePair.getRight();
            List<Long> percentMaxList = valueMap.get(ProcessorInformation.ProcessorFrequencyProperty.PERCENTOFMAXIMUMFREQUENCY);
            if (!instances.isEmpty()) {
                long maxFreq = this.getMaxFreq();
                long[] freqs = new long[this.getLogicalProcessorCount()];
                for (int p = 0; p < instances.size(); ++p) {
                    int cpu;
                    int n = cpu = instances.get(p).contains(",") ? this.numaNodeProcToLogicalProcMap.getOrDefault(instances.get(p), 0) : Builder.parseIntOrDefault(instances.get(p), 0);
                    if (cpu >= this.getLogicalProcessorCount()) continue;
                    freqs[cpu] = percentMaxList.get(cpu) * maxFreq / 100L;
                }
                return freqs;
            }
        }
        return this.queryNTPower(2);
    }

    @Override
    public long queryMaxFreq() {
        long[] freqs = this.queryNTPower(1);
        return Arrays.stream(freqs).max().orElse(-1L);
    }

    private long[] queryNTPower(int fieldIndex) {
        PowrProf.ProcessorPowerInformation ppi = new PowrProf.ProcessorPowerInformation();
        long[] freqs = new long[this.getLogicalProcessorCount()];
        int bufferSize = ppi.size() * freqs.length;
        Memory mem = new Memory((long)bufferSize);
        if (0 != PowrProf.INSTANCE.CallNtPowerInformation(11, null, 0, (Pointer)mem, bufferSize)) {
            Logger.error("Unable to get Processor Information", new Object[0]);
            Arrays.fill(freqs, -1L);
            return freqs;
        }
        for (int i = 0; i < freqs.length; ++i) {
            ppi = new PowrProf.ProcessorPowerInformation(mem.share((long)i * (long)ppi.size()));
            freqs[i] = fieldIndex == 1 ? (long)ppi.maxMhz * 1000000L : (fieldIndex == 2 ? (long)ppi.currentMhz * 1000000L : -1L);
        }
        return freqs;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        for (int i = 0; i < average.length; ++i) {
            average[i] = -1.0;
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        List<Long> idleList;
        List<Long> softIrqList;
        List<Long> irqList;
        List<Long> userList;
        List<Long> systemList;
        Map<Enum, List<Long>> valueMap;
        List<String> instances;
        Pair<List<String>, Map<Enum, List<Long>>> instanceValuePair;
        List<Long> systemUtility = null;
        List<Long> processorUtility = null;
        List<Long> processorUtilityBase = null;
        if (ProcessorInformation.USE_CPU_UTILITY) {
            instanceValuePair = ProcessorInformation.queryProcessorCapacityCounters();
            instances = instanceValuePair.getLeft();
            valueMap = instanceValuePair.getRight();
            systemList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPRIVILEGEDTIME);
            userList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTUSERTIME);
            irqList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTINTERRUPTTIME);
            softIrqList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTDPCTIME);
            idleList = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPROCESSORTIME);
            systemUtility = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPRIVILEGEDUTILITY);
            processorUtility = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPROCESSORUTILITY);
            processorUtilityBase = valueMap.get(ProcessorInformation.ProcessorCapacityTickCountProperty.PERCENTPROCESSORUTILITY_BASE);
        } else {
            instanceValuePair = ProcessorInformation.queryProcessorCounters();
            instances = instanceValuePair.getLeft();
            valueMap = instanceValuePair.getRight();
            systemList = valueMap.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTPRIVILEGEDTIME);
            userList = valueMap.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTUSERTIME);
            irqList = valueMap.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTINTERRUPTTIME);
            softIrqList = valueMap.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTDPCTIME);
            idleList = valueMap.get(ProcessorInformation.ProcessorTickCountProperty.PERCENTPROCESSORTIME);
        }
        int ncpu = this.getLogicalProcessorCount();
        long[][] ticks = new long[ncpu][CentralProcessor.TickType.values().length];
        if (instances.isEmpty() || systemList == null || userList == null || irqList == null || softIrqList == null || idleList == null || ProcessorInformation.USE_CPU_UTILITY && (systemUtility == null || processorUtility == null || processorUtilityBase == null)) {
            return ticks;
        }
        for (int p = 0; p < instances.size(); ++p) {
            int cpu;
            int n = cpu = instances.get(p).contains(",") ? this.numaNodeProcToLogicalProcMap.getOrDefault(instances.get(p), 0) : Builder.parseIntOrDefault(instances.get(p), 0);
            if (cpu >= ncpu) continue;
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = systemList.get(cpu);
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = userList.get(cpu);
            ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = irqList.get(cpu);
            ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()] = softIrqList.get(cpu);
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = idleList.get(cpu);
            if (ProcessorInformation.USE_CPU_UTILITY) {
                long elapsedTime = ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] + ticks[cpu][CentralProcessor.TickType.USER.getIndex()] + ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()];
                long deltaBase = processorUtilityBase.get(cpu) - this.baseticks[cpu];
                if (deltaBase > 0L) {
                    long deltaProc = processorUtility.get(cpu) - this.procticks[cpu];
                    long deltaSys = systemUtility.get(cpu) - this.privticks[cpu];
                    double idlePercent = 1.0 - (double)deltaProc / (100.0 * (double)deltaBase);
                    double sysPercent = (double)deltaSys / (100.0 * (double)deltaBase);
                    long deltaT = elapsedTime - this.elapsedticks[cpu];
                    long newIdle = this.idleticks[cpu] + Math.round((double)deltaT * idlePercent);
                    long newSystem = this.systicks[cpu] + Math.round((double)deltaT * sysPercent);
                    long delta = newIdle - ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()];
                    ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = newIdle;
                    ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = newSystem;
                    long[] lArray = ticks[cpu];
                    int n2 = CentralProcessor.TickType.USER.getIndex();
                    lArray[n2] = lArray[n2] - (delta += newSystem - ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()]);
                }
            }
            long[] lArray = ticks[cpu];
            int n3 = CentralProcessor.TickType.SYSTEM.getIndex();
            lArray[n3] = lArray[n3] - (ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] + ticks[cpu][CentralProcessor.TickType.SOFTIRQ.getIndex()]);
            long[] lArray2 = ticks[cpu];
            int n4 = CentralProcessor.TickType.SYSTEM.getIndex();
            lArray2[n4] = lArray2[n4] / 10000L;
            long[] lArray3 = ticks[cpu];
            int n5 = CentralProcessor.TickType.USER.getIndex();
            lArray3[n5] = lArray3[n5] / 10000L;
            long[] lArray4 = ticks[cpu];
            int n6 = CentralProcessor.TickType.IRQ.getIndex();
            lArray4[n6] = lArray4[n6] / 10000L;
            long[] lArray5 = ticks[cpu];
            int n7 = CentralProcessor.TickType.SOFTIRQ.getIndex();
            lArray5[n7] = lArray5[n7] / 10000L;
            long[] lArray6 = ticks[cpu];
            int n8 = CentralProcessor.TickType.IDLE.getIndex();
            lArray6[n8] = lArray6[n8] / 10000L;
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        return SystemInformation.queryContextSwitchCounters().getOrDefault(SystemInformation.ContextSwitchProperty.CONTEXTSWITCHESPERSEC, 0L);
    }

    @Override
    public long queryInterrupts() {
        return ProcessorInformation.queryInterruptCounters().getOrDefault(ProcessorInformation.InterruptsProperty.INTERRUPTSPERSEC, 0L);
    }
}

