/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.http.Httpv;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Process;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.bodys.FormBody;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.bodys.ProcessRequestBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.magic.RealResult;
import org.aoju.bus.http.metric.Cancelable;
import org.aoju.bus.http.metric.TaskExecutor;
import org.aoju.bus.http.metric.http.HttpMethod;

public abstract class CoverHttp<C extends CoverHttp<?>>
implements Cancelable {
    private static final String PATH_PARAM_REGEX = "[A-Za-z0-9_\\-/]*\\{[A-Za-z0-9_\\-]+\\}[A-Za-z0-9_\\-/]*";
    public Httpv httpv;
    public boolean nothrow;
    public boolean nextOnIO = false;
    public boolean skipPreproc = false;
    public boolean skipSerialPreproc = false;
    private String urlPath;
    private String tag;
    private Map<String, String> headers;
    private Map<String, String> pathParams;
    private Map<String, String> urlParams;
    private Map<String, String> bodyParams;
    private Map<String, FilePara> files;
    private Object requestBody;
    private String dateFormat;
    private String bodyType;
    private OnBack<Process> onProcess;
    private boolean processOnIO;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private Object object;
    private Httpv.TagTask tagTask;
    private Cancelable canceler;
    private Charset charset;

    public CoverHttp(Httpv httpv, String url) {
        this.urlPath = url;
        this.httpv = httpv;
        this.charset = httpv.charset();
        this.bodyType = httpv.bodyType();
    }

    public String getUrl() {
        return this.urlPath;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public boolean isTagged(String tag) {
        if (null != this.tag && null != tag) {
            return this.tag.contains(tag);
        }
        return false;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getBound() {
        return this.object;
    }

    public C nothrow() {
        this.nothrow = true;
        return (C)this;
    }

    public C skipPreproc() {
        this.skipPreproc = true;
        return (C)this;
    }

    public C skipSerialPreproc() {
        this.skipSerialPreproc = true;
        return (C)this;
    }

    public C tag(String tag) {
        if (null != tag) {
            this.tag = null != this.tag ? this.tag + "." + tag : tag;
            this.updateTagTask();
        }
        return (C)this;
    }

    public C charset(Charset charset) {
        if (null != charset) {
            this.charset = charset;
        }
        return (C)this;
    }

    public C bodyType(String type) {
        if (null != type) {
            this.bodyType = type;
        }
        return (C)this;
    }

    public C nextOnIO() {
        this.nextOnIO = true;
        return (C)this;
    }

    public C bind(Object object) {
        this.object = object;
        return (C)this;
    }

    public C addHeader(String name, String value) {
        if (null != name && null != value) {
            if (null == this.headers) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
        }
        return (C)this;
    }

    public C addHeader(Map<String, String> headers) {
        if (null != headers) {
            if (null == this.headers) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.putAll(headers);
        }
        return (C)this;
    }

    public C setRange(long rangeStart) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-");
    }

    public C setRange(long rangeStart, long rangeEnd) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-" + rangeEnd);
    }

    public C setOnProcess(OnBack<Process> onProcess) {
        this.onProcess = onProcess;
        this.processOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return (C)this;
    }

    public C stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return (C)this;
    }

    public C stepRate(double stepRate) {
        this.stepRate = stepRate;
        return (C)this;
    }

    public C addPathPara(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.pathParams) {
                this.pathParams = new HashMap<String, String>();
            }
            this.pathParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addPathPara(Map<String, ?> params) {
        if (null == this.pathParams) {
            this.pathParams = new HashMap<String, String>();
        }
        this.doAddParams(this.pathParams, params);
        return (C)this;
    }

    public C addUrlPara(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.urlParams) {
                this.urlParams = new HashMap<String, String>();
            }
            this.urlParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addUrlPara(Map<String, ?> params) {
        if (null == this.urlParams) {
            this.urlParams = new HashMap<String, String>();
        }
        this.doAddParams(this.urlParams, params);
        return (C)this;
    }

    public C addBodyPara(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.bodyParams) {
                this.bodyParams = new HashMap<String, String>();
            }
            this.bodyParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addBodyPara(Map<String, ?> params) {
        if (null == this.bodyParams) {
            this.bodyParams = new HashMap<String, String>();
        }
        this.doAddParams(this.bodyParams, params);
        return (C)this;
    }

    private void doAddParams(Map<String, String> taskParams, Map<String, ?> params) {
        if (null != params) {
            for (String name : params.keySet()) {
                Object value = params.get(name);
                if (null == name || null == value) continue;
                taskParams.put(name, value.toString());
            }
        }
    }

    public C setBodyPara(Object body) {
        this.requestBody = body;
        return (C)this;
    }

    public C addFilePara(String name, String filePath) {
        return this.addFilePara(name, new File(filePath));
    }

    public C addFilePara(String name, File file) {
        if (null != name && null != file && file.exists()) {
            String fileName = file.getName();
            String type = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (null == this.files) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, fileName, file));
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, byte[] content) {
        return this.addFilePara(name, type, null, content);
    }

    public C addFilePara(String name, String type, String fileName, byte[] content) {
        if (null != name && null != content) {
            if (null == this.files) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, fileName, content));
        }
        return (C)this;
    }

    @Override
    public boolean cancel() {
        if (null != this.canceler) {
            return this.canceler.cancel();
        }
        return false;
    }

    protected void registeTagTask(Cancelable canceler) {
        if (null != this.tag && null == this.tagTask) {
            this.tagTask = this.httpv.addTagTask(this.tag, canceler, this);
        }
        this.canceler = canceler;
    }

    private void updateTagTask() {
        if (null != this.tagTask) {
            this.tagTask.setTag(this.tag);
        } else if (null != this.canceler) {
            this.registeTagTask(this.canceler);
        }
    }

    protected void removeTagTask() {
        if (null != this.tag) {
            this.httpv.removeTagTask(this);
        }
    }

    protected NewCall prepareCall(String method) {
        Request request = this.prepareRequest(method);
        return this.httpv.request(request);
    }

    protected Request prepareRequest(String method) {
        boolean bodyCanUsed = HttpMethod.permitsRequestBody(method);
        this.assertNotConflict(!bodyCanUsed);
        Request.Builder builder = new Request.Builder().url(this.buildUrlPath());
        this.buildHeaders(builder);
        if (bodyCanUsed) {
            RequestBody reqBody = this.buildRequestBody();
            if (null != this.onProcess) {
                long contentLength = this.contentLength(reqBody);
                if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                    this.stepBytes = (long)((double)contentLength * this.stepRate);
                }
                if (this.stepBytes <= 0L) {
                    this.stepBytes = 8192L;
                }
                reqBody = new ProcessRequestBody(reqBody, this.onProcess, this.httpv.executor().getExecutor(this.processOnIO), contentLength, this.stepBytes);
            }
            builder.method(method, reqBody);
        } else {
            builder.method(method, null);
        }
        if (null != this.tag) {
            builder.tag(String.class, this.tag);
        }
        return builder.build();
    }

    private long contentLength(RequestBody reqBody) {
        try {
            return reqBody.contentLength();
        }
        catch (IOException e) {
            throw new InstrumentException("Cannot get the length of the request body", e);
        }
    }

    private void buildHeaders(Request.Builder builder) {
        if (null != this.headers) {
            for (String name : this.headers.keySet()) {
                String value = this.headers.get(name);
                if (null == value) continue;
                builder.addHeader(name, value);
            }
        }
    }

    public Results.State toState(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return Results.State.TIMEOUT;
        }
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return Results.State.NETWORK_ERROR;
        }
        String msg = e.getMessage();
        if (null != msg && ("Canceled".equals(msg) || e instanceof SocketException && (msg.startsWith("Socket operation on nonsocket") || "Socket closed".equals(msg)))) {
            return Results.State.CANCELED;
        }
        return Results.State.EXCEPTION;
    }

    private RequestBody buildRequestBody() {
        if (null != this.files) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            if (null != this.bodyParams) {
                for (String name : this.bodyParams.keySet()) {
                    byte[] value = this.bodyParams.get(name).getBytes(this.charset);
                    RequestBody body = RequestBody.create(null, value);
                    builder.addPart(MultipartBody.Part.createFormData(name, null, body));
                }
            }
            for (String name : this.files.keySet()) {
                FilePara file = this.files.get(name);
                MediaType type = this.httpv.mediaType(file.type);
                RequestBody bodyPart = null != file.file ? RequestBody.create(type, file.file) : RequestBody.create(type, file.content);
                builder.addFormDataPart(name, file.fileName, bodyPart);
            }
            return builder.build();
        }
        if (null != this.requestBody) {
            return this.toRequestBody(this.requestBody);
        }
        if (null == this.bodyParams) {
            return new FormBody.Builder(this.charset).build();
        }
        if ("form".equalsIgnoreCase(this.bodyType)) {
            FormBody.Builder builder = new FormBody.Builder(this.charset);
            for (String name : this.bodyParams.keySet()) {
                String value = this.bodyParams.get(name);
                builder.add(name, value);
            }
            return builder.build();
        }
        return this.toRequestBody(this.bodyParams);
    }

    private RequestBody toRequestBody(Object object) {
        if (object instanceof byte[] || object instanceof String) {
            String mediaType = this.httpv.executor().doMsgConvert((String)this.bodyType, null).mediaType;
            byte[] body = object instanceof byte[] ? (byte[])object : ((String)object).getBytes(this.charset);
            return RequestBody.create(MediaType.valueOf(mediaType + "; charset=" + this.charset.name()), body);
        }
        TaskExecutor.Data<byte[]> data = this.httpv.executor().doMsgConvert(this.bodyType, c -> c.serialize(object, this.dateFormat, this.charset));
        return RequestBody.create(MediaType.valueOf(data.mediaType + "; charset=" + this.charset.name()), (byte[])data.data);
    }

    private String buildUrlPath() {
        String url = this.urlPath;
        if (null == url || url.trim().isEmpty()) {
            throw new InstrumentException("Url cannot be empty!");
        }
        if (null != this.pathParams) {
            for (String name : this.pathParams.keySet()) {
                String target = "{" + name + "}";
                if (url.contains(target)) {
                    url = url.replace(target, this.pathParams.get(name));
                    continue;
                }
                throw new InstrumentException("pathParameter [ " + name + " ] Does not exist in url [ " + this.urlPath + " ]");
            }
        }
        if (url.matches(PATH_PARAM_REGEX)) {
            throw new InstrumentException("There is no setting for pathParameter in url, you must first call addPathParam to set it!");
        }
        if (null != this.urlParams) {
            url = this.buildUrl(url.trim());
        }
        return url;
    }

    private String buildUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        if (url.contains("?")) {
            if (!url.endsWith("?")) {
                if (url.lastIndexOf("=") < url.lastIndexOf("?") + 2) {
                    throw new InstrumentException("URL format error\uff0c'\uff1f' Not found after '='");
                }
                if (!url.endsWith("&")) {
                    sb.append('&');
                }
            }
        } else {
            sb.append('?');
        }
        for (String name : this.urlParams.keySet()) {
            sb.append(name).append('=').append(this.urlParams.get(name)).append('&');
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    protected void assertNotConflict(boolean bodyCantUsed) {
        if (bodyCantUsed) {
            if (ObjectKit.isNotEmpty(this.requestBody)) {
                throw new InstrumentException("GET | HEAD request The setBodyPara method cannot be called!");
            }
            if (MapKit.isNotEmpty(this.bodyParams)) {
                throw new InstrumentException("GET | HEAD request The addBodyPara method cannot be called!");
            }
            if (MapKit.isNotEmpty(this.files)) {
                throw new InstrumentException("GET | HEAD request The addFilePara method cannot be called!");
            }
        }
        if (ObjectKit.isNotEmpty(this.requestBody)) {
            if (MapKit.isNotEmpty(this.bodyParams)) {
                throw new InstrumentException("The methods addBodyPara and setBodyPara cannot be called at the same time!");
            }
            if (MapKit.isNotEmpty(this.files)) {
                throw new InstrumentException("The methods addFilePara and setBodyPara cannot be called at the same time!");
            }
        }
    }

    protected boolean timeoutAwait(CountDownLatch latch) {
        try {
            return latch.await(this.httpv.preprocTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InstrumentException("TimeOut " + (Object)((Object)Results.State.TIMEOUT));
        }
    }

    protected Results timeoutResult() {
        if (this.nothrow) {
            return new RealResult(this, Results.State.TIMEOUT);
        }
        throw new InstrumentException("Execution timeout " + (Object)((Object)Results.State.TIMEOUT));
    }

    public Charset charset(Response response) {
        ResponseBody b = response.body();
        MediaType type = null != b ? b.contentType() : null;
        return null != type ? type.charset(this.charset) : this.charset;
    }

    static class FilePara {
        String type;
        String fileName;
        byte[] content;
        File file;

        FilePara(String type, String fileName, byte[] content) {
            this.type = type;
            this.fileName = fileName;
            this.content = content;
        }

        FilePara(String type, String fileName, File file) {
            this.type = type;
            this.fileName = fileName;
            this.file = file;
        }
    }
}

