/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.stream.Stream;
import org.aoju.bus.image.galaxy.Property;

public class ScheduleExpression {
    private String dayOfWeek = "*";
    private String hour = "*";
    private int dayOfWeeks = -1;
    private int hours = -1;

    public static ScheduleExpression valueOf(String s) {
        ScheduleExpression result = new ScheduleExpression();
        for (String s1 : Property.split(s, ' ')) {
            if (s1.startsWith("hour=")) {
                try {
                    result.hour(s1.substring(5));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(s);
                }
            }
            if (s1.startsWith("dayOfWeek=")) {
                try {
                    result.dayOfWeek(s1.substring(10));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(s);
                }
            }
            throw new IllegalArgumentException(s);
        }
        return result;
    }

    public static ScheduleExpression[] valuesOf(String ... ss) {
        ScheduleExpression[] schedules = new ScheduleExpression[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            schedules[i] = ScheduleExpression.valueOf(ss[i]);
        }
        return schedules;
    }

    public static boolean emptyOrAnyContains(Calendar cal, ScheduleExpression ... expressions) {
        return expressions.length == 0 || Stream.of(expressions).anyMatch(expr -> expr.contains(cal));
    }

    public static Calendar ceil(Calendar cal, ScheduleExpression ... schedules) {
        if (schedules.length == 0) {
            return cal;
        }
        for (ScheduleExpression schedule : schedules) {
            if (!schedule.contains(cal)) continue;
            return cal;
        }
        Calendar cal2 = null;
        for (ScheduleExpression schedule : schedules) {
            Calendar cal3 = schedule.ceil(cal);
            if (null != cal2 && cal2.compareTo(cal3) <= 0) continue;
            cal2 = cal3;
        }
        return cal2;
    }

    public ScheduleExpression dayOfWeek(String s) {
        this.dayOfWeeks = this.parse(s, 7);
        this.dayOfWeek = s;
        return this;
    }

    public ScheduleExpression hour(String s) {
        this.hours = this.parse(s, 24);
        this.hour = s;
        return this;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getHour() {
        return this.hour;
    }

    public boolean contains(Calendar cal) {
        return this.containsHour(cal) && this.containsDayOfWeek(cal);
    }

    public Calendar ceil(Calendar cal) {
        if (this.contains(cal)) {
            return cal;
        }
        GregorianCalendar cal2 = new GregorianCalendar(cal.get(1), cal.get(2), cal.get(5));
        if (!this.containsDayOfWeek(cal2)) {
            do {
                ((Calendar)cal2).add(7, 1);
            } while (!this.containsDayOfWeek(cal2));
        } else {
            cal2.set(11, cal.get(11));
        }
        while (!this.containsHour(cal2)) {
            ((Calendar)cal2).add(11, 1);
        }
        return cal2;
    }

    private boolean containsDayOfWeek(Calendar cal) {
        return (1 << cal.get(7) - 1 & this.dayOfWeeks) != 0;
    }

    private boolean containsHour(Calendar cal) {
        return (1 << cal.get(11) & this.hours) != 0;
    }

    private int parse(String s, int m) {
        if (s.equals("*")) {
            return -1;
        }
        int result = -1 << m;
        for (String s1 : Property.split(s, ',')) {
            String[] range = Property.split(s1, '-');
            if (range.length > 2) {
                throw new IllegalArgumentException(s);
            }
            try {
                if (range.length == 1) {
                    result |= 1 << this.parseInt(s1, m);
                    continue;
                }
                int i = this.parseInt(range[0], m);
                int n = this.parseInt(range[1], m);
                while (i != n) {
                    result |= 1 << i;
                    i = (i + 1) % m;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(s);
            }
        }
        return result;
    }

    private int parseInt(String s, int m) {
        int i = Integer.parseInt(s);
        if (i < 0 || i >= m) {
            throw new IllegalArgumentException(s);
        }
        return i;
    }

    public String toString() {
        return "hour=" + this.hour + " dayOfWeek=" + this.dayOfWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleExpression that = (ScheduleExpression)o;
        return this.hours == that.hours && this.dayOfWeeks == that.dayOfWeeks;
    }

    public int hashCode() {
        int result = this.dayOfWeeks;
        result = 31 * result + this.hours;
        return 31 * this.hours + this.dayOfWeeks;
    }
}

