/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;

public class Sequence
extends ArrayList<Attributes>
implements Value {
    private final Attributes parent;
    private int length = -1;

    Sequence(Attributes parent, int initialCapacity) {
        super(initialCapacity);
        this.parent = parent;
    }

    public final Attributes getParent() {
        return this.parent;
    }

    private void setParent(Collection<? extends Attributes> c) {
        boolean bigEndian = this.parent.bigEndian();
        for (Attributes attributes : c) {
            if (attributes.bigEndian() != bigEndian) {
                throw new IllegalArgumentException("Endian of Item must match Endian of parent Data Set");
            }
            if (attributes.isRoot()) continue;
            throw new IllegalArgumentException("Item already contained by Sequence");
        }
        for (Attributes attributes : c) {
            attributes.setParent(this.parent);
        }
    }

    public void trimToSize(boolean recursive) {
        super.trimToSize();
        if (recursive) {
            for (Attributes attrs : this) {
                attrs.trimToSize(recursive);
            }
        }
    }

    @Override
    public boolean add(Attributes attrs) {
        return super.add(attrs.setParent(this.parent));
    }

    @Override
    public void add(int index, Attributes attrs) {
        super.add(index, attrs.setParent(this.parent));
    }

    @Override
    public boolean addAll(Collection<? extends Attributes> c) {
        this.setParent(c);
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Attributes> c) {
        this.setParent(c);
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        for (Attributes attrs : this) {
            attrs.setParent(null);
        }
        super.clear();
    }

    @Override
    public Attributes remove(int index) {
        return ((Attributes)super.remove(index)).setParent(null);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Attributes && super.remove(o)) {
            ((Attributes)o).setParent(null);
            return true;
        }
        return false;
    }

    @Override
    public Attributes set(int index, Attributes attrs) {
        return super.set(index, attrs.setParent(this.parent));
    }

    @Override
    public String toString() {
        return this.size() + " Items";
    }

    @Override
    public int calcLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
        int len = 0;
        for (Attributes item : this) {
            len += 8 + item.calcLength(encOpts, explicitVR);
            if (!(item.isEmpty() ? encOpts.undefEmptyItemLength : encOpts.undefItemLength)) continue;
            len += 8;
        }
        if (this.isEmpty() ? encOpts.undefEmptySequenceLength : encOpts.undefSequenceLength) {
            len += 8;
        }
        this.length = len;
        return len;
    }

    @Override
    public int getEncodedLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
        if (this.isEmpty()) {
            return encOpts.undefEmptySequenceLength ? -1 : 0;
        }
        if (encOpts.undefSequenceLength) {
            return -1;
        }
        if (this.length == -1) {
            this.calcLength(encOpts, explicitVR, vr);
        }
        return this.length;
    }

    @Override
    public void writeTo(ImageOutputStream out, VR vr) throws IOException {
        for (Attributes item : this) {
            item.writeItemTo(out);
        }
    }

    @Override
    public byte[] toBytes(VR vr, boolean bigEndian) {
        throw new UnsupportedOperationException();
    }
}

