/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.IOException;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.DimseRSP;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.logger.Logger;

public class FutureDimseRSP
extends DimseRSPHandler
implements DimseRSP {
    private Entry entry = new Entry(null, null);
    private boolean finished;
    private int autoCancel;
    private int remainingCapacity = Integer.MAX_VALUE;
    private IOException ex;

    public FutureDimseRSP(int msgID) {
        super(msgID);
    }

    @Override
    public synchronized void onDimseRSP(Association as, Attributes cmd, Attributes data) {
        super.onDimseRSP(as, cmd, data);
        Entry last = this.entry;
        while (null != last.next) {
            last = last.next;
        }
        last.next = new Entry(cmd, data);
        if (Status.isPending(cmd.getInt(2304, 0))) {
            if (this.autoCancel > 0 && --this.autoCancel == 0) {
                try {
                    super.cancel(as);
                }
                catch (IOException e) {
                    this.ex = e;
                }
            }
        } else {
            this.finished = true;
        }
        this.notifyAll();
        if (!this.finished && --this.remainingCapacity == 0) {
            try {
                Logger.debug("Wait for consuming DIMSE RSP", new Object[0]);
                while (null != this.ex && this.remainingCapacity == 0) {
                    this.wait();
                }
                Logger.debug("Stop waiting for consuming DIMSE RSP", new Object[0]);
            }
            catch (InterruptedException e) {
                Logger.warn("Failed to wait for consuming DIMSE RSP", e);
            }
        }
    }

    @Override
    public synchronized void onClose(Association as) {
        super.onClose(as);
        if (!this.finished) {
            this.ex = as.getException();
            if (null == this.ex) {
                this.ex = new IOException("Association to " + as.getRemoteAET() + " released before receive of outstanding DIMSE RSP");
            }
            this.notifyAll();
        }
    }

    public synchronized void setAutoCancel(int autoCancel) {
        this.autoCancel = autoCancel;
    }

    public void setCapacity(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        this.remainingCapacity = capacity;
    }

    @Override
    public void cancel(Association a) throws IOException {
        if (null != this.ex) {
            throw this.ex;
        }
        if (!this.finished) {
            super.cancel(a);
        }
    }

    @Override
    public final Attributes getCommand() {
        return this.entry.command;
    }

    @Override
    public final Attributes getDataset() {
        return this.entry.dataset;
    }

    @Override
    public synchronized boolean next() throws IOException, InterruptedException {
        if (null == this.entry.next) {
            if (this.finished) {
                return false;
            }
            if (null == this.entry.next && null == this.ex) {
                Logger.debug("Wait for next DIMSE RSP", new Object[0]);
                while (null == this.entry.next && null == this.ex) {
                    this.wait();
                }
                Logger.debug("Stop waiting for next DIMSE RSP", new Object[0]);
            }
            if (null != this.ex) {
                throw this.ex;
            }
        }
        this.entry = this.entry.next;
        if (this.remainingCapacity++ == 0) {
            this.notifyAll();
        }
        return true;
    }

    private static class Entry {
        final Attributes command;
        final Attributes dataset;
        Entry next;

        public Entry(Attributes command, Attributes dataset) {
            this.command = command;
            this.dataset = dataset;
        }
    }
}

