/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class WeChatMaProvider
extends AbstractProvider {
    public WeChatMaProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.WECHAT_MA, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        String url = Builder.fromUrl("https://api.weixin.qq.com/cgi-bin/token").queryParam("appid", this.context.getAppKey()).queryParam("secret", this.context.getAppSecret()).queryParam("grant_type", "client_credential").build();
        String response = Httpx.get(url);
        JSONObject object = this.checkResponse(response);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected Object getUserInfo(AccToken token) {
        return null;
    }

    @Override
    public Message login(Callback callback) {
        String response = this.doGetAuthorizationCode(callback.getCode());
        JSONObject object = this.checkResponse(response);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(object).build();
    }

    @Override
    public Message refresh(AccToken token) {
        AccToken accToken = this.getAccessToken(null);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(accToken).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.authorize()).queryParam("appid", this.context.getAppKey()).queryParam("secret", this.context.getAppSecret()).queryParam("grant_type", "authorization_code").queryParam("js_code", code).build();
    }

    public JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode")) {
            throw new AuthorizedException(StringKit.toString(object.getIntValue("errcode")), object.getString("errmsg"));
        }
        return object;
    }
}

