/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class XiaomiProvider
extends AbstractProvider {
    public XiaomiProvider(Context context) {
        super(context, Registry.XIAOMI);
    }

    public XiaomiProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.XIAOMI, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    private AccToken getToken(String accessTokenUrl) {
        String response = Httpx.get(accessTokenUrl);
        JSONObject object = JSONObject.parseObject((String)StringKit.replace((CharSequence)response, (CharSequence)"&&&START&&&", ""));
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).scope(object.getString("scope")).tokenType(object.getString("token_type")).refreshToken(object.getString("refresh_token")).openId(object.getString("openId")).macAlgorithm(object.getString("mac_algorithm")).macKey(object.getString("mac_key")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject jsonObject = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        if ("error".equalsIgnoreCase(jsonObject.getString("result"))) {
            throw new AuthorizedException(jsonObject.getString("description"));
        }
        JSONObject object = jsonObject.getJSONObject("data");
        Property property = Property.builder().rawJson(object).uuid(accToken.getOpenId()).username(object.getString("miliaoNick")).nickname(object.getString("miliaoNick")).avatar(object.getString("miliaoIcon")).email(object.getString("mail")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
        String emailPhoneUrl = MessageFormat.format("{0}?clientId={1}&token={2}", "https://open.account.xiaomi.com/user/phoneAndEmail", this.context.getAppKey(), accToken.getAccessToken());
        JSONObject userEmailPhone = JSONObject.parseObject((String)Httpx.get(emailPhoneUrl));
        if (!"error".equalsIgnoreCase(userEmailPhone.getString("result"))) {
            JSONObject emailPhone = userEmailPhone.getJSONObject("data");
            property.setEmail(emailPhone.getString("email"));
        }
        return property;
    }

    @Override
    public Message refresh(AccToken accToken) {
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(accToken.getRefreshToken()))).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("skip_confirm", "false").queryParam("scope", this.getScopes(" ", true, XiaomiProvider.getScopes(true, OauthScope.Mi.values()))).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("clientId", this.context.getAppKey()).queryParam("token", accToken.getAccessToken()).build();
    }
}

