/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.util.List;
import org.aoju.bus.logger.Logger;

public final class OfficeOption {
    private String product = "???";
    private String version = "???";
    private boolean useLongOptionNameGnuStyle;

    private OfficeOption() {
    }

    public static OfficeOption fromHelpOutput(List<String> lines) {
        OfficeOption desc = new OfficeOption();
        Logger.debug("Building {} from help output lines", OfficeOption.class.getName());
        String productLine = null;
        for (String line : lines) {
            if (line.contains("--help")) {
                desc.useLongOptionNameGnuStyle = true;
                continue;
            }
            String lowerLine = line.trim().toLowerCase();
            if (!lowerLine.startsWith("openoffice") && !lowerLine.startsWith("libreoffice")) continue;
            productLine = line.trim();
        }
        if (null != productLine) {
            String[] parts = productLine.split(" ");
            if (parts.length > 0) {
                desc.product = parts[0];
            }
            if (parts.length > 1) {
                desc.version = parts[1];
            }
        }
        Logger.info("soffice info (from help output): {}", desc.toString());
        return desc;
    }

    public static OfficeOption fromExecutablePath(String path) {
        OfficeOption desc = new OfficeOption();
        if (path.toLowerCase().contains("openoffice")) {
            desc.product = "OpenOffice";
            desc.useLongOptionNameGnuStyle = false;
        }
        if (path.toLowerCase().contains("libreoffice")) {
            desc.product = "LibreOffice";
            desc.useLongOptionNameGnuStyle = true;
        }
        Logger.info("soffice info (from exec path): {}", desc.toString());
        return desc;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean useLongOptionNameGnuStyle() {
        return this.useLongOptionNameGnuStyle;
    }

    public String toString() {
        return String.format("Product: %s - Version: %s - useLongOptionNameGnuStyle: %s", this.getProduct(), this.getVersion(), this.useLongOptionNameGnuStyle());
    }
}

