/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.aoju.bus.office.support.excel.sax.ExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.RowHandler;
import org.aoju.bus.office.support.excel.sax.SheetRidReader;
import org.aoju.bus.office.support.excel.sax.SheetSaxHandler;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public class Excel07SaxReader
implements ExcelSaxReader<Excel07SaxReader> {
    private final SheetSaxHandler handler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.handler = new SheetSaxHandler(rowHandler);
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.handler.setRowHandler(rowHandler);
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws InstrumentException {
        return this.read(file, "rId" + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(File file, String idOrRidOrSheetName) throws InstrumentException {
        try (OPCPackage open = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            Excel07SaxReader excel07SaxReader = this.read(open, idOrRidOrSheetName);
            return excel07SaxReader;
        }
        catch (IOException | InvalidFormatException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws InstrumentException {
        return this.read(in, "rId" + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(InputStream in, String idOrRidOrSheetName) throws InstrumentException {
        try (OPCPackage opcPackage = OPCPackage.open((InputStream)in);){
            Excel07SaxReader excel07SaxReader = this.read(opcPackage, idOrRidOrSheetName);
            return excel07SaxReader;
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        catch (InvalidFormatException e) {
            throw new InstrumentException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws InstrumentException {
        return this.read(opcPackage, "rId" + rid);
    }

    public Excel07SaxReader read(OPCPackage opcPackage, String idOrRidOrSheetName) throws InstrumentException {
        try {
            return this.read(new XSSFReader(opcPackage), idOrRidOrSheetName);
        }
        catch (OpenXML4JException e) {
            throw new InstrumentException(e);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public Excel07SaxReader read(XSSFReader xssfReader, String idOrRidOrSheetName) throws InstrumentException {
        try {
            this.handler.stylesTable = xssfReader.getStylesTable();
        }
        catch (IOException | InvalidFormatException throwable) {
            // empty catch block
        }
        try {
            this.handler.sharedStringsTable = xssfReader.getSharedStringsTable();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        catch (InvalidFormatException e) {
            throw new InstrumentException(e);
        }
        return this.readSheets(xssfReader, idOrRidOrSheetName);
    }

    private Excel07SaxReader readSheets(XSSFReader xssfReader, String idOrRidOrSheetName) throws InstrumentException {
        this.handler.sheetIndex = this.getSheetIndex(xssfReader, idOrRidOrSheetName);
        InputStream sheetInputStream = null;
        try {
            if (this.handler.sheetIndex > -1) {
                sheetInputStream = xssfReader.getSheet("rId" + (this.handler.sheetIndex + 1));
                ExcelSaxKit.readFrom(sheetInputStream, this.handler);
                this.handler.rowHandler.doAfterAllAnalysed();
            } else {
                this.handler.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.handler.index = 0;
                    ++this.handler.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxKit.readFrom(sheetInputStream, this.handler);
                    this.handler.rowHandler.doAfterAllAnalysed();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(sheetInputStream);
        }
        return this;
    }

    private int getSheetIndex(XSSFReader xssfReader, String idOrRidOrSheetName) {
        if (StringKit.startWithIgnoreCase(idOrRidOrSheetName, "rId")) {
            return Integer.parseInt(StringKit.removePrefixIgnoreCase(idOrRidOrSheetName, "rId"));
        }
        SheetRidReader ridReader = SheetRidReader.parse(xssfReader);
        if (StringKit.startWithIgnoreCase(idOrRidOrSheetName, "sheetName:")) {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName = StringKit.removePrefixIgnoreCase(idOrRidOrSheetName, "sheetName:"));
            if (null != rid) {
                return rid;
            }
        } else {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName);
            if (null != rid) {
                return rid;
            }
            try {
                int sheetIndex = Integer.parseInt(idOrRidOrSheetName);
                rid = ridReader.getRidBySheetIdBase0(sheetIndex);
                return ObjectKit.defaultIfNull(rid, sheetIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid rId or id or sheetName: " + idOrRidOrSheetName);
    }
}

