/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.bridge;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.setting.Builder;
import org.aoju.bus.starter.bridge.BridgeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class BridgePropertyLoader
implements PropertySourceLoader,
Ordered {
    @Autowired
    private BridgeProperties properties;
    private String profiles = null;

    public String[] getFileExtensions() {
        return new String[]{"properties", "yml", "yaml"};
    }

    public List<PropertySource<?>> load(String name, Resource resource) throws IOException {
        Properties property = new Properties();
        if (name.contains("properties")) {
            property.load(resource.getInputStream());
        } else {
            YamlPropertiesFactoryBean bean = new YamlPropertiesFactoryBean();
            bean.setResources(new Resource[]{resource});
            property = bean.getObject();
        }
        if (this.profiles == null) {
            this.profiles = property.getProperty("spring.profiles.active");
        } else {
            Logger.info("spring.profiles.active = " + this.profiles + ",ignore load remote config", new Object[0]);
        }
        if (this.profiles == null) {
            this.mergeProperties(property);
            OriginTrackedMapPropertySource props = new OriginTrackedMapPropertySource(name, (Map)property);
            return Collections.singletonList(props);
        }
        return Collections.singletonList(new OriginTrackedMapPropertySource(name, (Map)property));
    }

    public int getOrder() {
        return -2147483637;
    }

    public void mergeProperties(Properties properties) {
        String url = String.format("%s?method=%s&v=%s&format=%s&appKey=%s&profile=%s", this.properties.getUrl(), this.properties.getMethod(), this.properties.getVersion(), this.properties.getFormat(), this.properties.getAppKey(), this.properties.getProfile());
        Logger.debug("fetch configs url:" + url, new Object[0]);
        String response = Httpx.get(url);
        Map map = (Map)JsonKit.toMap(response).get("data");
        if (map == null) {
            throw new RuntimeException("fetch remote config error!");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Builder.parseYamlMap(result, (String)map.get("content"));
        for (Map.Entry entry : map.entrySet()) {
            properties.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            String value = entry.getValue().toString();
            if (!value.contains("${")) continue;
            value = Builder.replaceRefValue(properties, value);
            properties.setProperty(entry.getKey().toString(), value);
        }
    }
}

