/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.logger.Logger;
import org.apache.ibatis.cache.Cache;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ReflectionUtils;

public class MapperCacheDisabler
implements InitializingBean {
    public void afterPropertiesSet() {
        this.disableCaching();
    }

    private void disableCaching() {
        try {
            ClassLoader appClassLoader = this.getClass().getClassLoader();
            this.removeStaticCache(ClassKit.forName("org.aoju.bus.mapper.reflect.Reflector", appClassLoader), "CLASS_CACHE");
            this.removeStaticCache(ClassKit.forName("org.aoju.bus.mapper.genid.GenId", appClassLoader));
            this.removeStaticCache(ClassKit.forName("org.aoju.bus.mapper.version.DefaultNextVersion", appClassLoader));
            this.removeEntityHelperCache(ClassKit.forName("org.aoju.bus.mapper.builder.EntityBuilder", appClassLoader));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeStaticCache(Class<?> utilClass) {
        this.removeStaticCache(utilClass, "CACHE");
    }

    private void removeStaticCache(Class<?> utilClass, String fieldName) {
        try {
            Field cacheField = ReflectionUtils.findField(utilClass, (String)fieldName);
            if (cacheField != null) {
                ReflectionUtils.makeAccessible((Field)cacheField);
                Object cache = ReflectionUtils.getField((Field)cacheField, null);
                if (cache instanceof Map) {
                    ((Map)cache).clear();
                } else if (cache instanceof Cache) {
                    ((Cache)cache).clear();
                } else {
                    throw new UnsupportedOperationException("cache field must be a java.util.Map or org.apache.ibatis.cache.Cache instance");
                }
                Logger.info("Clear " + utilClass.getCanonicalName() + " " + fieldName + " cache.", new Object[0]);
            }
        }
        catch (Exception ex) {
            Logger.warn("Failed to disable " + utilClass.getCanonicalName() + " " + fieldName + " cache. ClassCastExceptions may occur", ex);
        }
    }

    private void removeEntityHelperCache(Class<?> entityHelper) {
        try {
            Field cacheField = ReflectionUtils.findField(entityHelper, (String)"entityTableMap");
            if (cacheField != null) {
                ReflectionUtils.makeAccessible((Field)cacheField);
                Map cache = (Map)ReflectionUtils.getField((Field)cacheField, null);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                for (Object key : new ArrayList(cache.keySet())) {
                    Class entityClass = (Class)key;
                    if (entityClass.getClassLoader().equals(classLoader) || entityClass.getClassLoader().equals(classLoader.getParent())) continue;
                    cache.remove(entityClass);
                }
                Logger.info("Clear EntityHelper entityTableMap cache.", new Object[0]);
            }
        }
        catch (Exception ex) {
            Logger.warn("Failed to disable Mapper MsUtil cache. ClassCastExceptions may occur", ex);
        }
    }
}

