/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.copier.AbstractCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.toolkit.TypeKit;

public class MapToMapCopier
extends AbstractCopier<Map, Map> {
    private final Type targetType;

    public MapToMapCopier(Map source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public Map copy() {
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            String sKeyStr = this.copyOptions.editFieldName(sKey.toString());
            if (null == sKeyStr) {
                return;
            }
            Object targetValue = ((Map)this.target).get(sKeyStr);
            if (!this.copyOptions.override && null != targetValue) {
                return;
            }
            Type[] typeArguments = TypeKit.getTypeArguments(this.targetType);
            if (null != typeArguments) {
                sValue = Convert.convertWithCheck(typeArguments[1], sValue, null, this.copyOptions.ignoreError);
                sValue = this.copyOptions.editFieldValue(sKeyStr, sValue);
            }
            ((Map)this.target).put(sKeyStr, sValue);
        });
        return (Map)this.target;
    }
}

