/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compiler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.UriKit;

public class JavaSourceFileObject
extends SimpleJavaFileObject {
    private InputStream inputStream;

    protected JavaSourceFileObject(URI uri) {
        super(uri, JavaFileObject.Kind.SOURCE);
    }

    protected JavaSourceFileObject(String className, String code, java.nio.charset.Charset charset) {
        this(className, IoKit.toStream(code, charset));
    }

    protected JavaSourceFileObject(String name, InputStream inputStream) {
        this(UriKit.getStringURI(name.replace(".", "/") + JavaFileObject.Kind.SOURCE.extension));
        this.inputStream = inputStream;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.toUri().toURL().openStream();
        }
        return new BufferedInputStream(this.inputStream);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        try (InputStream in = this.openInputStream();){
            String string = IoKit.read(in, Charset.UTF_8);
            return string;
        }
    }
}

