/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.copier.Duplicate;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;

public class FileCopier
extends Duplicate<File, FileCopier> {
    private boolean isOverride;
    private boolean isCopyAttributes;
    private boolean isCopyContentIfDir;
    private boolean isOnlyCopyFile;

    public FileCopier(File src, File dest) {
        this.src = src;
        this.dest = dest;
    }

    public static FileCopier create(String srcPath, String destPath) {
        return new FileCopier(FileKit.file(srcPath), FileKit.file(destPath));
    }

    public static FileCopier create(File src, File dest) {
        return new FileCopier(src, dest);
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public FileCopier setOverride(boolean isOverride) {
        this.isOverride = isOverride;
        return this;
    }

    public boolean isCopyAttributes() {
        return this.isCopyAttributes;
    }

    public FileCopier setCopyAttributes(boolean isCopyAttributes) {
        this.isCopyAttributes = isCopyAttributes;
        return this;
    }

    public boolean isCopyContentIfDir() {
        return this.isCopyContentIfDir;
    }

    public FileCopier setCopyContentIfDir(boolean isCopyContentIfDir) {
        this.isCopyContentIfDir = isCopyContentIfDir;
        return this;
    }

    public boolean isOnlyCopyFile() {
        return this.isOnlyCopyFile;
    }

    public FileCopier setOnlyCopyFile(boolean isOnlyCopyFile) {
        this.isOnlyCopyFile = isOnlyCopyFile;
        return this;
    }

    @Override
    public File copy() throws InstrumentException {
        File src = (File)this.src;
        File dest = (File)this.dest;
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new InstrumentException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directory is null !", new Object[0]);
        if (FileKit.equals(src, dest)) {
            throw new InstrumentException("Files '{" + src + "}' and '{" + dest + "}' are equal");
        }
        if (src.isDirectory()) {
            if (dest.exists() && !dest.isDirectory()) {
                throw new InstrumentException("Src is a directory but dest is a file!");
            }
            File subTarget = this.isCopyContentIfDir ? dest : FileKit.mkdir(FileKit.file(dest, src.getName()));
            this.internalCopyDirContent(src, subTarget);
        } else {
            this.internalCopyFile(src, dest);
        }
        return dest;
    }

    private void internalCopyDirContent(File src, File dest) throws InstrumentException {
        if (null != this.copyFilter && !this.copyFilter.accept(src)) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        } else if (!dest.isDirectory()) {
            throw new InstrumentException(StringKit.format((CharSequence)"Src [{}] is a directory but dest [{}] is a file!", src.getPath(), dest.getPath()));
        }
        String[] files = src.list();
        if (ArrayKit.isNotEmpty(files)) {
            for (String file : files) {
                File destFile;
                File srcFile = new File(src, file);
                File file2 = destFile = this.isOnlyCopyFile ? dest : new File(dest, file);
                if (srcFile.isDirectory()) {
                    this.internalCopyDirContent(srcFile, destFile);
                    continue;
                }
                this.internalCopyFile(srcFile, destFile);
            }
        }
    }

    private void internalCopyFile(File src, File dest) throws InstrumentException {
        if (null != this.copyFilter && !this.copyFilter.accept(src)) {
            return;
        }
        if (dest.exists()) {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (dest.exists() && !this.isOverride) {
                return;
            }
        } else {
            FileKit.mkParentDirs(dest);
        }
        ArrayList<StandardCopyOption> optionList = new ArrayList<StandardCopyOption>(2);
        if (this.isOverride) {
            optionList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (this.isCopyAttributes) {
            optionList.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        try {
            Files.copy(src.toPath(), dest.toPath(), optionList.toArray(new CopyOption[0]));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }
}

