/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class ClassPathResource
extends UriResource {
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, null, null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this(path, classLoader, null);
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this(path, null, clazz);
    }

    public ClassPathResource(String pathBaseClassLoader, ClassLoader classLoader, Class<?> clazz) {
        String path;
        Assert.notNull(pathBaseClassLoader, "Path must not be null", new Object[0]);
        this.path = path = this.normalizePath(pathBaseClassLoader);
        this.name = StringKit.isBlank(path) ? null : FileKit.getName(path);
        this.classLoader = ObjectKit.defaultIfNull(classLoader, ClassKit::getClassLoader);
        this.clazz = clazz;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final String getAbsolutePath() {
        if (FileKit.isAbsolutePath(this.path)) {
            return this.path;
        }
        return FileKit.normalize(UriKit.getDecodedPath(this.url));
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new InstrumentException("Resource of path [{}] not exist!", this.path);
        }
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : "classpath:" + this.path;
    }

    private String normalizePath(String path) {
        path = FileKit.normalize(path);
        path = StringKit.removePrefix(path, "/");
        Assert.isFalse(FileKit.isAbsolutePath(path), "Path [{}] must be a relative path !", path);
        return path;
    }
}

