/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.key;

import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.key.NanoId;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.key.Snowflake;
import org.aoju.bus.core.key.UUID;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.NetKit;
import org.aoju.bus.core.toolkit.RuntimeKit;

public class ID {
    public static String objectId() {
        return ObjectID.id();
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString(true);
    }

    public static String fastUUID() {
        return UUID.fastUUID().toString();
    }

    public static String fastSimpleUUID() {
        return UUID.fastUUID().toString(true);
    }

    public static Snowflake getSnowflake(long workerId, long datacenterId) {
        return Instances.singletion(Snowflake.class, workerId, datacenterId);
    }

    public static long getSnowflake(long workerId) {
        return ID.getSnowflake().getWorkerId(workerId);
    }

    public static Snowflake getSnowflake() {
        return Instances.singletion(Snowflake.class);
    }

    public static long getSnowflakeNextId() {
        return ID.getSnowflake().nextId();
    }

    public static long getDataCenterId(long maxDatacenterId) {
        Assert.isTrue(maxDatacenterId > 0L, "maxDatacenterId must be > 0", new Object[0]);
        if (maxDatacenterId == Long.MAX_VALUE) {
            --maxDatacenterId;
        }
        long id = 1L;
        byte[] mac = null;
        try {
            mac = NetKit.getLocalHardwareAddress();
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        try {
            mpid.append(RuntimeKit.getPid());
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public static String nanoId() {
        return NanoId.randomNanoId();
    }

    public static String nanoId(int size) {
        return NanoId.randomNanoId(size);
    }
}

