/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.map.MapWrapper;
import org.aoju.bus.core.toolkit.CollKit;

public abstract class AbstractCollValueMap<K, V, C extends Collection<V>>
extends MapWrapper<K, C> {
    protected static final int DEFAULT_COLLECTION_INITIAL_CAPACITY = 3;

    public AbstractCollValueMap() {
        this(16);
    }

    public AbstractCollValueMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public AbstractCollValueMap(Map<? extends K, C> m) {
        this(0.75f, m);
    }

    public AbstractCollValueMap(float loadFactor, Map<? extends K, C> m) {
        this(m.size(), loadFactor);
        this.putAll(m);
    }

    public AbstractCollValueMap(int initialCapacity, float loadFactor) {
        super(new HashMap(initialCapacity, loadFactor));
    }

    public void putAllValues(Map<? extends K, ? extends Collection<V>> m) {
        if (null != m) {
            m.forEach((? super K key, ? super V valueColl) -> {
                if (null != valueColl) {
                    valueColl.forEach((? super T value) -> this.putValue(key, value));
                }
            });
        }
    }

    public void putValue(K key, V value) {
        Collection<Object> collection = (Collection)this.get(key);
        if (null == collection) {
            collection = this.createCollection();
            this.put(key, collection);
        }
        collection.add(value);
    }

    public V get(K key, int index) {
        Collection collection = (Collection)this.get(key);
        return (V)CollKit.get(collection, index);
    }

    protected abstract C createCollection();
}

