/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.collection.ComputeIterator;
import org.aoju.bus.core.map.AbstractEntry;
import org.aoju.bus.core.map.AbstractTable;
import org.aoju.bus.core.toolkit.IterKit;

public class RowKeyTable<R, C, V>
extends AbstractTable<R, C, V> {
    final Map<R, Map<C, V>> raw;
    final Builder<? extends Map<C, V>> columnBuilder;
    private Map<C, Map<R, V>> columnMap;
    private Set<C> columnKeySet;

    public RowKeyTable() {
        this(new HashMap());
    }

    public RowKeyTable(Map<R, Map<C, V>> raw) {
        this(raw, HashMap::new);
    }

    public RowKeyTable(Map<R, Map<C, V>> raw, Builder<? extends Map<C, V>> columnMapBuilder) {
        this.raw = raw;
        this.columnBuilder = null == columnMapBuilder ? HashMap::new : columnMapBuilder;
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        return this.raw;
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        return this.raw.computeIfAbsent(rowKey, key -> this.columnBuilder.build()).put(columnKey, value);
    }

    @Override
    public V remove(R rowKey, C columnKey) {
        Map map = this.getRow(rowKey);
        if (null == map) {
            return null;
        }
        Object value = map.remove(columnKey);
        if (map.isEmpty()) {
            this.raw.remove(rowKey);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    @Override
    public void clear() {
        this.raw.clear();
    }

    @Override
    public boolean containsColumn(C columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map<C, V> map : this.raw.values()) {
            if (null == map || !map.containsKey(columnKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap result = this.columnMap;
        return result == null ? (this.columnMap = new ColumnMap()) : result;
    }

    @Override
    public Set<C> columnKeySet() {
        ColumnKeySet result = this.columnKeySet;
        return result == null ? (this.columnKeySet = new ColumnKeySet()) : result;
    }

    @Override
    public Map<R, V> getColumn(C columnKey) {
        return new Column(columnKey);
    }

    private class ColumnMap
    extends AbstractMap<C, Map<R, V>> {
        private ColumnMap() {
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> entrySet() {
            return new ColumnMapEntrySet();
        }
    }

    private class ColumnKeySet
    extends AbstractSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return new ColumnKeyIterator();
        }

        @Override
        public int size() {
            return IterKit.size(this.iterator());
        }
    }

    private class Column
    extends AbstractMap<R, V> {
        final C columnKey;

        Column(C columnKey) {
            this.columnKey = columnKey;
        }

        @Override
        public Set<Map.Entry<R, V>> entrySet() {
            return new EntrySet();
        }

        private class EntrySet
        extends AbstractSet<Map.Entry<R, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (Map map : RowKeyTable.this.raw.values()) {
                    if (!map.containsKey(Column.this.columnKey)) continue;
                    ++size;
                }
                return size;
            }
        }

        private class EntrySetIterator
        extends ComputeIterator<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            private EntrySetIterator() {
                this.iterator = RowKeyTable.this.raw.entrySet().iterator();
            }

            @Override
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    final Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    return new AbstractEntry<R, V>(){

                        @Override
                        public R getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)entry.getValue()).get(Column.this.columnKey);
                        }

                        @Override
                        public V setValue(V value) {
                            return ((Map)entry.getValue()).put(Column.this.columnKey, value);
                        }
                    };
                }
                return null;
            }
        }
    }

    private class ColumnKeyIterator
    extends ComputeIterator<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = RowKeyTable.this.columnBuilder.build();
            this.mapIterator = RowKeyTable.this.raw.values().iterator();
            this.entryIterator = IterKit.empty();
        }

        @Override
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return entry.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return null;
        }
    }

    private class ColumnMapEntrySet
    extends AbstractSet<Map.Entry<C, Map<R, V>>> {
        private final Set<C> columnKeySet;

        private ColumnMapEntrySet() {
            this.columnKeySet = RowKeyTable.this.columnKeySet();
        }

        @Override
        public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
            return new AbstractTable.TransIterator<Object, Map.Entry>(this.columnKeySet.iterator(), c -> new AbstractMap.SimpleEntry(c, RowKeyTable.this.getColumn(c)));
        }

        @Override
        public int size() {
            return this.columnKeySet.size();
        }
    }
}

