/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.lang.function.Consumer3;
import org.aoju.bus.core.toolkit.MapKit;

public interface Table<R, C, V>
extends Iterable<Cell<R, C, V>> {
    default public boolean contains(R rowKey, C columnKey) {
        return Optional.ofNullable(this.getRow(rowKey)).map(map -> map.containsKey(columnKey)).get();
    }

    default public boolean containsRow(R rowKey) {
        return Optional.ofNullable(this.rowMap()).map(map -> map.containsKey(rowKey)).get();
    }

    default public Map<C, V> getRow(R rowKey) {
        return Optional.ofNullable(this.rowMap()).map(map -> (Map)map.get(rowKey)).get();
    }

    default public Set<R> rowKeySet() {
        return Optional.ofNullable(this.rowMap()).map(Map::keySet).get();
    }

    public Map<R, Map<C, V>> rowMap();

    default public boolean containsColumn(C columnKey) {
        return Optional.ofNullable(this.columnMap()).map(map -> map.containsKey(columnKey)).get();
    }

    default public Map<R, V> getColumn(C columnKey) {
        return Optional.ofNullable(this.columnMap()).map(map -> (Map)map.get(columnKey)).get();
    }

    default public Set<C> columnKeySet() {
        return Optional.ofNullable(this.columnMap()).map(Map::keySet).get();
    }

    public Map<C, Map<R, V>> columnMap();

    default public boolean containsValue(V value) {
        Collection rows = Optional.ofNullable(this.rowMap()).map(Map::values).get();
        if (null != rows) {
            for (Map row : rows) {
                if (!row.containsValue(value)) continue;
                return true;
            }
        }
        return false;
    }

    default public V get(R rowKey, C columnKey) {
        return (V)Optional.ofNullable(this.getRow(rowKey)).map(map -> map.get(columnKey)).get();
    }

    public Collection<V> values();

    public Set<Cell<R, C, V>> cellSet();

    public V put(R var1, C var2, V var3);

    default public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        if (null != table) {
            for (Cell<R, C, V> cell : table.cellSet()) {
                this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
        }
    }

    public V remove(R var1, C var2);

    public boolean isEmpty();

    default public int size() {
        Map<R, Map<C, V>> rowMap = this.rowMap();
        if (MapKit.isEmpty(rowMap)) {
            return 0;
        }
        int size = 0;
        for (Map<C, V> map : rowMap.values()) {
            size += map.size();
        }
        return size;
    }

    public void clear();

    default public void forEach(Consumer3<? super R, ? super C, ? super V> consumer) {
        for (Cell cell : this) {
            consumer.accept(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    public static interface Cell<R, C, V> {
        public R getRowKey();

        public C getColumnKey();

        public V getValue();
    }
}

