/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aoju.bus.core.annotation.Alias;
import org.aoju.bus.core.collection.UniqueKeySet;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.SimpleCache;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ReflectKit {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final SimpleCache<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> METHODS_CACHE = new SimpleCache();

    public static Object invokeGetter(Object obj, String name) {
        Object object = obj;
        for (String method : StringKit.splitToArray((CharSequence)name, ".")) {
            String getterMethodName = "get" + StringKit.capitalize(method);
            object = ReflectKit.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object obj, String name, Object value) {
        Object object = obj;
        String[] names = StringKit.splitToArray((CharSequence)name, ".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = "get" + StringKit.capitalize(names[i]);
                object = ReflectKit.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = "set" + StringKit.capitalize(names[i]);
            ReflectKit.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static Object convert(Object obj, Class<?> type) {
        if (obj instanceof Number) {
            Number number = (Number)obj;
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return number.byteValue();
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return number.shortValue();
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return number.intValue();
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return number.longValue();
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(number.floatValue());
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return number.doubleValue();
            }
        }
        if (type.equals(String.class)) {
            return null == obj ? "" : obj.toString();
        }
        return obj;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectKit.invokeMethod(method, target, Normal.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeMethod(Object obj, String name, Class<?>[] types, Object[] args) {
        Method method = ReflectKit.getAccessibleMethod(obj, name, types);
        if (null == method) {
            throw new IllegalArgumentException("Could not find method [" + method + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectKit.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeMethodByName(Object obj, String name, Object[] args) {
        Method method = ReflectKit.getAccessibleMethodByName(obj, name);
        if (null == method) {
            throw new IllegalArgumentException("Could not find method [" + name + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectKit.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Field getAccessibleField(Object obj, String name) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(name);
                ReflectKit.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String name, Class<?> ... types) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(name, types);
                ReflectKit.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String name) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                ReflectKit.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectKit.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Class<?> clazz = instance.getClass();
        if (null != clazz && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && null != (superClass = clazz.getSuperclass()) && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static boolean hasField(Object obj, String fieldName) {
        Field field = ReflectKit.getAccessibleField(obj, fieldName);
        return null != field;
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassKit.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.get(beanClass, () -> ReflectKit.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectKit.getFields(beanClass);
        return ArrayKit.firstNonNull(field -> name.equals(ReflectKit.getFieldName(field)), fields);
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.get(beanClass, () -> ReflectKit.getFields(beanClass, true));
    }

    public static Field[] getFields(Class<?> beanClass, Filter<Field> fieldFilter) throws SecurityException {
        return ArrayKit.filter(ReflectKit.getFields(beanClass), fieldFilter);
    }

    public static Field[] getFields(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (null != searchType) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayKit.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static String getFieldName(Field field) {
        if (null == field) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field.getName();
    }

    public static Object getFieldValue(Object obj, String fieldName) throws InstrumentException {
        if (null == obj || StringKit.isBlank(fieldName)) {
            return null;
        }
        return ReflectKit.getFieldValue(obj, ReflectKit.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) throws InstrumentException {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectKit.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = ReflectKit.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass()))) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = ReflectKit.getFieldValue(obj, fields[i]);
            }
            return values;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws InstrumentException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = ReflectKit.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        ReflectKit.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws InstrumentException {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassKit.getDefaultValue(fieldType);
        }
        ReflectKit.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("IllegalAccess for {}.{}", obj, field.getName());
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StringKit.isBlank(methodName)) {
            return null;
        }
        return ReflectKit.getMethod(obj.getClass(), methodName, ClassKit.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectKit.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectKit.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringKit.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectKit.getMethods(clazz);
        if (ArrayKit.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StringKit.equals(methodName, method.getName(), ignoreCase) || !ArrayKit.isEmpty(paramTypes) && !ClassKit.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectKit.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectKit.getMethods(clazz);
        if (null == filter) {
            return methods;
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (!filter.accept(method)) continue;
            methodList.add(method);
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.get(beanClass, () -> ReflectKit.getMethods(beanClass, true, true));
    }

    public static Method[] getMethods(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result = new UniqueKeySet<String, Method>(true, ReflectKit::getUniqueKey);
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result.addAllIfAbsent(ReflectKit.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && false == searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result.toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return null != method && ObjectKit.equal(method.getName(), "hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return null != method && ObjectKit.equal(method.getName(), "toString") && method.getParameterTypes().length == 0;
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return ReflectKit.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount > 1) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        switch (parameterCount) {
            case 0: {
                return name.startsWith("get") || name.startsWith("is");
            }
            case 1: {
                return name.startsWith("set");
            }
        }
        return false;
    }

    public static <T> T newInstance(String clazz) throws InstrumentException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new InstrumentException(StringKit.format((CharSequence)"Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws InstrumentException {
        if (ArrayKit.isEmpty(params)) {
            try {
                return clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new InstrumentException(StringKit.format((CharSequence)"Instance class [{}] error!", clazz), e);
            }
        }
        Class<?>[] paramTypes = ClassKit.getClasses(params);
        Constructor<T> constructor = ReflectKit.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new InstrumentException("No Constructor matched for parameter types: [" + new Object[]{paramTypes} + "]");
        }
        try {
            return ReflectKit.getConstructor(clazz, paramTypes).newInstance(params);
        }
        catch (Exception e) {
            throw new InstrumentException(StringKit.format((CharSequence)"Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass) {
        Assert.notNull(beanClass);
        if (beanClass.isAssignableFrom(AbstractMap.class)) {
            beanClass = HashMap.class;
        } else if (beanClass.isAssignableFrom(List.class)) {
            beanClass = ArrayList.class;
        } else if (beanClass.isAssignableFrom(Set.class)) {
            beanClass = HashSet.class;
        }
        try {
            return (T)ReflectKit.newInstance(beanClass, new Object[0]);
        }
        catch (InstrumentException instrumentException) {
            Constructor<T>[] constructors;
            for (Constructor<T> constructor : constructors = ReflectKit.getConstructors(beanClass)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectKit.setAccessible(constructor);
                try {
                    return constructor.newInstance(ClassKit.getDefaultValues(parameterTypes));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws InstrumentException {
        return ReflectKit.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws InstrumentException {
        Class<?>[] types = method.getParameterTypes();
        if (null != types && null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassKit.getDefaultValue(type);
            }
        }
        return ReflectKit.invoke(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) {
        ReflectKit.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassKit.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convert(parameterTypes[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        try {
            return (T)method.invoke(ClassKit.isStatic(method) ? null : obj, actualArgs);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) {
        Method method = ReflectKit.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new InstrumentException(StringKit.format((CharSequence)"No such method: [{}]", methodName));
        }
        return ReflectKit.invoke(obj, method, args);
    }

    public static String getGetMethodName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String getSetMethodName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ClassKit.isAbstract(m)) continue;
                result.add(m);
            }
        }
        return result;
    }
}

