/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aoju.bus.core.collection.EnumerationIterator;
import org.aoju.bus.core.compress.Deflate;
import org.aoju.bus.core.compress.Gzip;
import org.aoju.bus.core.compress.ZipCopyVisitor;
import org.aoju.bus.core.compress.ZipReader;
import org.aoju.bus.core.compress.ZipWriter;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ZipKit {
    private static final int DEFAULT_BYTE_ARRAY_LENGTH = 32;
    private static final java.nio.charset.Charset DEFAULT_CHARSET = java.nio.charset.Charset.defaultCharset();

    public static File zip(String srcPath) throws InstrumentException {
        return ZipKit.zip(srcPath, DEFAULT_CHARSET);
    }

    public static File zip(String srcPath, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.zip(FileKit.file(srcPath), charset);
    }

    public static File zip(File srcFile) throws InstrumentException {
        return ZipKit.zip(srcFile, DEFAULT_CHARSET);
    }

    public static File zip(File srcFile, java.nio.charset.Charset charset) throws InstrumentException {
        File zipFile = FileKit.file(srcFile.getParentFile(), FileKit.getPrefix(srcFile) + ".zip");
        ZipKit.zip(zipFile, charset, false, srcFile);
        return zipFile;
    }

    public static File zip(String srcPath, String zipPath) throws InstrumentException {
        return ZipKit.zip(srcPath, zipPath, false);
    }

    public static File zip(String srcPath, String zipPath, boolean withSrcDir) throws InstrumentException {
        return ZipKit.zip(srcPath, zipPath, DEFAULT_CHARSET, withSrcDir);
    }

    public static File zip(String srcPath, String zipPath, java.nio.charset.Charset charset, boolean withSrcDir) throws InstrumentException {
        File srcFile = FileKit.file(srcPath);
        File zipFile = FileKit.file(zipPath);
        ZipKit.zip(zipFile, charset, withSrcDir, srcFile);
        return zipFile;
    }

    public static File zip(File zipFile, boolean withSrcDir, File ... srcFiles) throws InstrumentException {
        return ZipKit.zip(zipFile, DEFAULT_CHARSET, withSrcDir, srcFiles);
    }

    public static File zip(File zipFile, java.nio.charset.Charset charset, boolean withSrcDir, File ... srcFiles) throws InstrumentException {
        return ZipKit.zip(zipFile, charset, withSrcDir, null, srcFiles);
    }

    public static File zip(File zipFile, java.nio.charset.Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) throws InstrumentException {
        ZipKit.validateFiles(zipFile, srcFiles);
        ZipWriter.of(zipFile, charset).add(withSrcDir, filter, srcFiles).close();
        return zipFile;
    }

    public static void zip(OutputStream out, java.nio.charset.Charset charset, boolean withSrcDir, FileFilter filter, File ... srcFiles) {
        ZipWriter.of(out, charset).add(withSrcDir, filter, srcFiles).close();
    }

    public static void zip(ZipOutputStream zipOutputStream, boolean withSrcDir, FileFilter filter, File ... srcFiles) {
        try (ZipWriter zipWriter = new ZipWriter(zipOutputStream);){
            zipWriter.add(withSrcDir, filter, srcFiles);
        }
    }

    public static File zip(File zipFile, String path, String data) throws InstrumentException {
        return ZipKit.zip(zipFile, path, data, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, String data, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.zip(zipFile, path, IoKit.toStream(data, charset), charset);
    }

    public static File zip(File zipFile, String path, InputStream in) throws InstrumentException {
        return ZipKit.zip(zipFile, path, in, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String path, InputStream in, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.zip(zipFile, new String[]{path}, new InputStream[]{in}, charset);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins) throws InstrumentException {
        return ZipKit.zip(zipFile, paths, ins, DEFAULT_CHARSET);
    }

    public static File zip(File zipFile, String[] paths, InputStream[] ins, java.nio.charset.Charset charset) throws InstrumentException {
        if (ArrayKit.isEmpty(paths) || ArrayKit.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        try (ZipWriter zipWriter = ZipWriter.of(zipFile, charset);){
            for (int i = 0; i < paths.length; ++i) {
                zipWriter.add(paths[i], ins[i]);
            }
        }
        return zipFile;
    }

    public static void zip(OutputStream out, String[] paths, InputStream[] ins) {
        if (ArrayKit.isEmpty(paths) || ArrayKit.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        try (ZipWriter zipWriter = ZipWriter.of(out, DEFAULT_CHARSET);){
            for (int i = 0; i < paths.length; ++i) {
                zipWriter.add(paths[i], ins[i]);
            }
        }
    }

    public static void zip(ZipOutputStream zipOutputStream, String[] paths, InputStream[] ins) throws InstrumentException {
        if (ArrayKit.isEmpty(paths) || ArrayKit.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        try (ZipWriter zipWriter = new ZipWriter(zipOutputStream);){
            for (int i = 0; i < paths.length; ++i) {
                zipWriter.add(paths[i], ins[i]);
            }
        }
    }

    public static File zip(File zipFile, java.nio.charset.Charset charset, Resource ... resources) throws InstrumentException {
        ZipWriter.of(zipFile, charset).add(resources).close();
        return zipFile;
    }

    public static File unzip(String zipFilePath) throws InstrumentException {
        return ZipKit.unzip(zipFilePath, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(FileKit.file(zipFilePath), charset);
    }

    public static File unzip(File zipFile) throws InstrumentException {
        return ZipKit.unzip(zipFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(zipFile, FileKit.file(zipFile.getParentFile(), FileKit.getPrefix(zipFile)), charset);
    }

    public static File unzip(String zipFilePath, String outFileDir) throws InstrumentException {
        return ZipKit.unzip(zipFilePath, outFileDir, DEFAULT_CHARSET);
    }

    public static File unzip(String zipFilePath, String outFileDir, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(FileKit.file(zipFilePath), FileKit.mkdir(outFileDir), charset);
    }

    public static File unzip(File zipFile, File outFile) throws InstrumentException {
        return ZipKit.unzip(zipFile, outFile, DEFAULT_CHARSET);
    }

    public static File unzip(File zipFile, File outFile, java.nio.charset.Charset charset) throws InstrumentException {
        return ZipKit.unzip(ZipKit.zipFile(zipFile, charset), outFile);
    }

    public static File unzip(ZipFile zipFile, File outFile) {
        if (outFile.exists() && outFile.isFile()) {
            throw new IllegalArgumentException(StringKit.format((CharSequence)"Target path [{}] exist!", outFile.getAbsolutePath()));
        }
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.readTo(outFile);
        }
        return outFile;
    }

    public static File unzip(InputStream in, File outFile, java.nio.charset.Charset charset) {
        if (null == charset) {
            charset = DEFAULT_CHARSET;
        }
        return ZipKit.unzip(new ZipInputStream(in, charset), outFile);
    }

    public static File unzip(ZipInputStream zipStream, File outFile) {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.readTo(outFile);
        }
        return outFile;
    }

    public static byte[] unzipFileBytes(String zipFilePath, String name) {
        return ZipKit.unzipFileBytes(zipFilePath, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(String zipFilePath, java.nio.charset.Charset charset, String name) {
        return ZipKit.unzipFileBytes(FileKit.file(zipFilePath), charset, name);
    }

    public static byte[] unzipFileBytes(File zipFile, String name) {
        return ZipKit.unzipFileBytes(zipFile, DEFAULT_CHARSET, name);
    }

    public static byte[] unzipFileBytes(File zipFile, java.nio.charset.Charset charset, String name) {
        try (ZipReader reader = ZipReader.of(zipFile, charset);){
            byte[] byArray = IoKit.readBytes(reader.get(name));
            return byArray;
        }
    }

    public static byte[] gzip(String content, String charset) throws InstrumentException {
        return ZipKit.gzip(StringKit.bytes((CharSequence)content, charset));
    }

    public static byte[] gzip(byte[] buf) throws InstrumentException {
        return ZipKit.gzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] gzip(File file) throws InstrumentException {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byte[] byArray = ZipKit.gzip(in, (int)file.length());
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }

    public static byte[] gzip(InputStream in) throws InstrumentException {
        return ZipKit.gzip(in, 32);
    }

    public static byte[] gzip(InputStream in, int length) throws InstrumentException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Gzip.of(in, bos).gzip().close();
        return bos.toByteArray();
    }

    public static String unGzip(byte[] buf, String charset) throws InstrumentException {
        return StringKit.toString(ZipKit.unGzip(buf), charset);
    }

    public static byte[] unGzip(byte[] buf) throws InstrumentException {
        return ZipKit.unGzip(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unGzip(InputStream in) throws InstrumentException {
        return ZipKit.unGzip(in, 32);
    }

    public static byte[] unGzip(InputStream in, int length) throws InstrumentException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        Gzip.of(in, bos).unGzip().close();
        return bos.toByteArray();
    }

    public static byte[] zlib(String content, String charset, int level) {
        return ZipKit.zlib(StringKit.bytes((CharSequence)content, charset), level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zlib(File file, int level) {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            byte[] byArray = ZipKit.zlib(in, level, (int)file.length());
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }

    public static byte[] zlib(byte[] buf, int level) {
        return ZipKit.zlib(new ByteArrayInputStream(buf), level, buf.length);
    }

    public static byte[] zlib(InputStream in, int level) {
        return ZipKit.zlib(in, level, 32);
    }

    public static byte[] zlib(InputStream in, int level, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).deflater(level);
        return out.toByteArray();
    }

    public static String unZlib(byte[] buf, String charset) {
        return StringKit.toString(ZipKit.unZlib(buf), charset);
    }

    public static byte[] unZlib(byte[] buf) {
        return ZipKit.unZlib(new ByteArrayInputStream(buf), buf.length);
    }

    public static byte[] unZlib(InputStream in) {
        return ZipKit.unZlib(in, 32);
    }

    public static byte[] unZlib(InputStream in, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        Deflate.of(in, out, false).inflater();
        return out.toByteArray();
    }

    public static InputStream get(File zipFile, java.nio.charset.Charset charset, String path) {
        return ZipKit.get(ZipKit.zipFile(zipFile, charset), path);
    }

    public static InputStream get(ZipFile zipFile, String path) {
        ZipEntry entry = zipFile.getEntry(path);
        if (null != entry) {
            return ZipKit.get(zipFile, entry);
        }
        return null;
    }

    public static InputStream get(ZipFile zipFile, ZipEntry zipEntry) {
        try {
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void get(ZipFile zipFile, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipFile);){
            reader.read(consumer);
        }
    }

    public static void get(ZipInputStream zipStream, Consumer<ZipEntry> consumer) {
        try (ZipReader reader = new ZipReader(zipStream);){
            reader.read(consumer);
        }
    }

    private static ZipOutputStream get(OutputStream out, java.nio.charset.Charset charset) {
        if (out instanceof ZipOutputStream) {
            return (ZipOutputStream)out;
        }
        return new ZipOutputStream(out, ObjectKit.defaultIfNull(charset, DEFAULT_CHARSET));
    }

    public static ZipFile zipFile(File file, java.nio.charset.Charset charset) {
        try {
            return new ZipFile(file, ObjectKit.defaultIfNull(charset, Charset.UTF_8));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static List<String> listFileNames(ZipFile zipFile, String dir) {
        if (StringKit.isNotBlank(dir)) {
            dir = StringKit.addSuffixIfNot(dir, "/");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (ZipEntry zipEntry : new EnumerationIterator<ZipEntry>(zipFile.entries())) {
            String nameSuffix;
            String name = zipEntry.getName();
            if (!StringKit.isEmpty(dir) && !name.startsWith(dir) || !StringKit.isNotEmpty(nameSuffix = StringKit.removePrefix(name, dir)) || StringKit.contains((CharSequence)nameSuffix, "/")) continue;
            fileNames.add(nameSuffix);
        }
        return fileNames;
    }

    public static void append(Path zipPath, Path appendFilePath, CopyOption ... options) throws IOException {
        try (FileSystem zipFileSystem = ZipKit.createZip(zipPath.toString());){
            if (Files.isDirectory(appendFilePath, new LinkOption[0])) {
                Path source = appendFilePath.getParent();
                if (null == source) {
                    source = appendFilePath;
                }
                Files.walkFileTree(appendFilePath, new ZipCopyVisitor(source, zipFileSystem, options));
            } else {
                Files.copy(appendFilePath, zipFileSystem.getPath(FileKit.getName(appendFilePath), new String[0]), options);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    public static FileSystem create(String path) {
        try {
            return FileSystems.newFileSystem(Paths.get(path, new String[0]).toUri(), MapKit.of("create", "true"));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static FileSystem createZip(String path) {
        return ZipKit.createZip(path, null);
    }

    public static FileSystem createZip(String path, java.nio.charset.Charset charset) {
        if (null == charset) {
            charset = Charset.UTF_8;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        env.put("encoding", charset.name());
        try {
            return FileSystems.newFileSystem(URI.create("jar:" + Paths.get(path, new String[0]).toUri()), env);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    private static void validateFiles(File zipFile, File ... srcFiles) throws InstrumentException {
        if (zipFile.isDirectory()) {
            throw new InstrumentException("Zip file [{}] must not be a directory !", zipFile.getAbsoluteFile());
        }
        for (File srcFile : srcFiles) {
            File parentFile;
            if (null == srcFile) continue;
            if (!srcFile.exists()) {
                throw new InstrumentException(StringKit.format((CharSequence)"File [{}] not exist!", srcFile.getAbsolutePath()));
            }
            try {
                parentFile = zipFile.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                parentFile = zipFile.getParentFile();
            }
            if (!srcFile.isDirectory() || !FileKit.isSub(srcFile, parentFile)) continue;
            throw new InstrumentException("Zip file path [{}] must not be the child directory of [{}] !", zipFile.getPath(), srcFile.getPath());
        }
    }

    private static void write(ZipFile zipFile, ZipEntry zipEntry, File outItemFile) throws InstrumentException {
        FileKit.writeFromStream(ZipKit.get(zipFile, zipEntry), outItemFile);
    }
}

