/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.matcher;

import java.util.Collections;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.pattern.matcher.ValueMatcher;

public class BoolArrayValueMatcher
implements ValueMatcher {
    private final int minValue;
    private final boolean[] values;

    public BoolArrayValueMatcher(List<Integer> intValueList) {
        Assert.isTrue(CollKit.isNotEmpty(intValueList), "Values must be not empty!", new Object[0]);
        this.values = new boolean[Collections.max(intValueList) + 1];
        int min = Integer.MAX_VALUE;
        for (Integer value : intValueList) {
            min = Math.min(min, value);
            this.values[value.intValue()] = true;
        }
        this.minValue = min;
    }

    @Override
    public boolean match(Integer value) {
        if (null == value || value >= this.values.length) {
            return false;
        }
        return this.values[value];
    }

    @Override
    public int nextAfter(int value) {
        if (value > this.minValue) {
            while (value < this.values.length) {
                if (this.values[value]) {
                    return value;
                }
                ++value;
            }
        }
        return this.minValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public String toString() {
        return StringKit.format((CharSequence)"Matcher:{}", new Object[]{this.values});
    }
}

