/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.matcher;

import java.time.Year;
import org.aoju.bus.cron.pattern.matcher.DayOfMonthValueMatcher;
import org.aoju.bus.cron.pattern.matcher.ValueMatcher;

public class DateTimeMatcher {
    final ValueMatcher secondMatcher;
    final ValueMatcher minuteMatcher;
    final ValueMatcher hourMatcher;
    final ValueMatcher dayOfMonthMatcher;
    final ValueMatcher monthMatcher;
    final ValueMatcher dayOfWeekMatcher;
    final ValueMatcher yearMatcher;

    public DateTimeMatcher(ValueMatcher secondMatcher, ValueMatcher minuteMatcher, ValueMatcher hourMatchers, ValueMatcher dayOfMonthMatchers, ValueMatcher monthMatchers, ValueMatcher dayOfWeekMatchers, ValueMatcher yearMatchers) {
        this.secondMatcher = secondMatcher;
        this.minuteMatcher = minuteMatcher;
        this.hourMatcher = hourMatchers;
        this.dayOfMonthMatcher = dayOfMonthMatchers;
        this.monthMatcher = monthMatchers;
        this.dayOfWeekMatcher = dayOfWeekMatchers;
        this.yearMatcher = yearMatchers;
    }

    private static boolean isMatchDayOfMonth(ValueMatcher matcher, int dayOfMonth, int month, boolean isLeapYear) {
        return matcher instanceof DayOfMonthValueMatcher ? ((DayOfMonthValueMatcher)matcher).match(dayOfMonth, month, isLeapYear) : matcher.match(dayOfMonth);
    }

    public boolean match(int second, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        return (second < 0 || this.secondMatcher.match(second)) && this.minuteMatcher.match(minute) && this.hourMatcher.match(hour) && DateTimeMatcher.isMatchDayOfMonth(this.dayOfMonthMatcher, dayOfMonth, month, Year.isLeap(year)) && this.monthMatcher.match(month) && this.dayOfWeekMatcher.match(dayOfWeek) && this.yearMatcher.match(year);
    }
}

