/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.lang.exception.CrontabException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.pattern.matcher.AlwaysTrueValueMatcher;
import org.aoju.bus.cron.pattern.matcher.BoolArrayValueMatcher;
import org.aoju.bus.cron.pattern.matcher.ValueMatcher;
import org.aoju.bus.cron.pattern.parser.ValueParser;

public abstract class AbstractValueParser
implements ValueParser {
    protected int min;
    protected int max;

    public AbstractValueParser(int min, int max) {
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    private static boolean isMatchAllStr(String value) {
        return 1 == value.length() && ("*".equals(value) || "?".equals(value));
    }

    @Override
    public int parse(String value) throws CrontabException {
        int i;
        if ("L".equalsIgnoreCase(value)) {
            return this.max;
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new CrontabException("Invalid integer value: '{}'", value);
        }
        if (i < this.min || i > this.max) {
            throw new CrontabException("Value {} out of range: [{} , {}]", i, this.min, this.max);
        }
        return i;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public ValueMatcher parseAsValueMatcher(String value) {
        if (AbstractValueParser.isMatchAllStr(value)) {
            return new AlwaysTrueValueMatcher();
        }
        List<Integer> values = this.parseArray(value);
        if (values.size() == 0) {
            throw new CrontabException("Invalid field: [{}]", value);
        }
        return this.buildValueMatcher(values);
    }

    protected ValueMatcher buildValueMatcher(List<Integer> values) {
        return new BoolArrayValueMatcher(values);
    }

    private List<Integer> parseArray(String value) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List<String> parts = StringKit.split((CharSequence)value, ',');
        for (String part : parts) {
            CollKit.addAllIfNotContains(values, this.parseStep(part));
        }
        return values;
    }

    private List<Integer> parseStep(String value) {
        List<Integer> results;
        List<String> parts = StringKit.split((CharSequence)value, '/');
        int size = parts.size();
        if (size == 1) {
            results = this.parseRange(value, -1);
        } else if (size == 2) {
            int step = this.parse(parts.get(1));
            if (step < 1) {
                throw new CrontabException("Non positive divisor for field: [{}]", value);
            }
            results = this.parseRange(parts.get(0), step);
        } else {
            throw new CrontabException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private List<Integer> parseRange(String value, int step) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value.length() <= 2) {
            int minValue = this.getMin();
            if (!AbstractValueParser.isMatchAllStr(value)) {
                minValue = Math.max(minValue, this.parse(value));
            } else if (step < 1) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = this.getMax();
                if (minValue > maxValue) {
                    throw new CrontabException("Invalid value {} > {}", minValue, maxValue);
                }
                for (int i = minValue; i <= maxValue; i += step) {
                    results.add(i);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List<String> parts = StringKit.split((CharSequence)value, '-');
        int size = parts.size();
        if (size == 1) {
            int v1 = this.parse(value);
            if (step > 0) {
                MathKit.appendRange(v1, this.getMax(), step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = this.parse(parts.get(0));
            int v2 = this.parse(parts.get(1));
            if (step < 1) {
                step = 1;
            }
            if (v1 < v2) {
                MathKit.appendRange(v1, v2, step, results);
            } else if (v1 > v2) {
                MathKit.appendRange(v1, this.getMax(), step, results);
                MathKit.appendRange(this.getMin(), v2, step, results);
            } else {
                MathKit.appendRange(v1, this.getMax(), step, results);
            }
        } else {
            throw new CrontabException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }
}

